/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ChooseTestSuiteBP;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractStartTestHandler;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class StartTestSuiteHandler
extends AbstractStartTestHandler
implements IElementUpdater {
    public static final String TEST_SUITE_TO_START = "org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.parameter.testSuiteToStart";
    public static final String RUNNING_AUT = "org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.parameter.runningAut";
    public static final String LAST_STARTED_TEST_SUITE = "org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.state.lastStartedSuite";
    public static final String LAST_TESTED_RUNNING_AUT = "org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.state.lastRunningAut";

    public Object executeImpl(ExecutionEvent event) {
        Object testSuiteToStartObj = null;
        Object runningAutObj = null;
        ITestSuitePO testSuiteToStart = null;
        AutIdentifier runningAut = null;
        try {
            testSuiteToStartObj = event.getObjectParameterForExecution(TEST_SUITE_TO_START);
            runningAutObj = event.getObjectParameterForExecution(RUNNING_AUT);
        }
        catch (ExecutionException executionException) {}
        if (testSuiteToStartObj instanceof ITestSuitePO && runningAutObj instanceof AutIdentifier) {
            testSuiteToStart = (ITestSuitePO)testSuiteToStartObj;
            runningAut = (AutIdentifier)runningAutObj;
        } else {
            State lastStartedTestSuiteState = event.getCommand().getState(LAST_STARTED_TEST_SUITE);
            State lastTestedRunningAutState = event.getCommand().getState(LAST_TESTED_RUNNING_AUT);
            if (lastStartedTestSuiteState != null && lastTestedRunningAutState != null) {
                Object testSuiteStateValue = lastStartedTestSuiteState.getValue();
                Object runningAutStateValue = lastTestedRunningAutState.getValue();
                if (testSuiteStateValue instanceof ITestSuitePO && runningAutStateValue instanceof AutIdentifier) {
                    testSuiteToStart = (ITestSuitePO)testSuiteStateValue;
                    runningAut = (AutIdentifier)runningAutStateValue;
                }
            }
        }
        if (testSuiteToStart != null && runningAut != null && this.initTestExecution()) {
            boolean autoScreenshots = Plugin.getDefault().getPreferenceStore().getBoolean("AUTO_SCREENSHOT_PREF_KEY");
            ChooseTestSuiteBP.getInstance().runTestSuite(testSuiteToStart, runningAut, autoScreenshots);
            State lastStartedAutState = event.getCommand().getState(LAST_STARTED_TEST_SUITE);
            State lastStartedAutConfigState = event.getCommand().getState(LAST_TESTED_RUNNING_AUT);
            if (lastStartedAutState != null && lastStartedAutConfigState != null) {
                lastStartedAutState.setValue((Object)testSuiteToStart);
                lastStartedAutConfigState.setValue((Object)runningAut);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        AutIdentifier lastUsedAUT;
        boolean check = false;
        Object testSuiteToStart = parameters.get(TEST_SUITE_TO_START);
        Object autToUse = parameters.get(RUNNING_AUT);
        ChooseTestSuiteBP ctsBP = ChooseTestSuiteBP.getInstance();
        ITestSuitePO lastUsedTestSuite = ctsBP.getLastUsedTestSuite();
        if (lastUsedTestSuite != null && lastUsedTestSuite.getId().toString().equals(testSuiteToStart) && (lastUsedAUT = ctsBP.getLastUsedAUT()) != null && lastUsedAUT.getExecutableName().equals(autToUse)) {
            check = true;
        }
        element.setChecked(check);
    }
}

