/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ComponentNameReuseBP;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ComponentNameBrowserContentProvider
extends LabelProvider
implements ITreeContentProvider,
IColorProvider {
    private static final Color DISABLED_COLOR = LayoutUtil.GRAY_COLOR;
    private static final Object[] DUMMY = new Object[0];
    private TreeViewer m_viewer;
    private Map<Object, Object> m_relationShip = new HashMap<Object, Object>();

    public Object[] getChildren(Object parentO) {
        Object[] children = DUMMY;
        if (parentO instanceof IProjectPO || parentO instanceof IReusedProjectPO) {
            Long parentProjectID = null;
            if (parentO instanceof IProjectPO) {
                parentProjectID = ((IProjectPO)parentO).getId();
            } else {
                IReusedProjectPO rp = (IReusedProjectPO)parentO;
                try {
                    parentProjectID = ProjectPM.findProjectId((String)rp.getProjectGuid(), (Integer)rp.getMajorNumber(), (Integer)rp.getMinorNumber());
                }
                catch (JBException jBException) {}
            }
            if (parentProjectID != null) {
                UsedCompnamesCategory usedCat = new UsedCompnamesCategory(parentProjectID, parentO);
                UnusedCompnamesCategory unCat = new UnusedCompnamesCategory(parentProjectID, parentO);
                try {
                    IProjectPO project = parentO instanceof IProjectPO ? (IProjectPO)parentO : ProjectPM.loadProjectById((Long)parentProjectID);
                    if (project.getUsedProjects().size() > 0) {
                        ReusedCompnamesCategory reusedCat = new ReusedCompnamesCategory(parentProjectID, parentO);
                        children = new AbstractCompNamesCategory[]{usedCat, unCat, reusedCat};
                    } else {
                        children = new AbstractCompNamesCategory[]{usedCat, unCat};
                    }
                }
                catch (JBException jBException) {}
            }
        }
        if (parentO instanceof AbstractCompNamesCategory) {
            AbstractCompNamesCategory pe = (AbstractCompNamesCategory)parentO;
            if (pe instanceof UsedCompnamesCategory) {
                children = this.findUsedCompNames(pe);
            }
            if (pe instanceof UnusedCompnamesCategory) {
                children = this.findUnusedCompNames(pe);
            }
            if (pe instanceof ReusedCompnamesCategory) {
                children = this.findAllReusedProjects(pe);
            }
        }
        if (children != DUMMY) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.m_relationShip.put(o, parentO);
                ++n2;
            }
        }
        return children;
    }

    private Object[] findAllReusedProjects(AbstractCompNamesCategory pe) {
        try {
            IProjectPO rp = ProjectPM.loadProjectById((Long)pe.getParentProjectID());
            return rp.getUsedProjects().toArray();
        }
        catch (JBException jBException) {
            return DUMMY;
        }
    }

    private Object[] findUnusedCompNames(AbstractCompNamesCategory pe) {
        try {
            Collection cn = ComponentNamesBP.getInstance().getAllNonRefCompNamePOs(Long.valueOf(pe.getParentProjectID()));
            CollectionUtils.filter((Collection)cn, (Predicate)new Predicate(){

                public boolean evaluate(Object element) {
                    if (element instanceof IComponentNamePO) {
                        IComponentNamePO compName = (IComponentNamePO)element;
                        if (ComponentNameReuseBP.getInstance().isCompNameReused(compName.getGuid())) {
                            return false;
                        }
                    }
                    return true;
                }
            });
            return cn.toArray();
        }
        catch (PMException pMException) {
            return DUMMY;
        }
    }

    private Object[] findUsedCompNames(AbstractCompNamesCategory pe) {
        try {
            Collection cn = ComponentNamesBP.getInstance().getAllNonRefCompNamePOs(Long.valueOf(pe.getParentProjectID()));
            CollectionUtils.filter((Collection)cn, (Predicate)new Predicate(){

                public boolean evaluate(Object element) {
                    if (element instanceof IComponentNamePO) {
                        IComponentNamePO compName = (IComponentNamePO)element;
                        if (ComponentNameReuseBP.getInstance().isCompNameReused(compName.getGuid())) {
                            return true;
                        }
                    }
                    return false;
                }
            });
            return cn.toArray();
        }
        catch (PMException pMException) {
            return DUMMY;
        }
    }

    public Object getParent(Object element) {
        return this.m_relationShip.get(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        this.m_relationShip.clear();
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.m_relationShip.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.setViewer((TreeViewer)viewer);
        }
    }

    public String getText(Object element) {
        if (element instanceof AbstractCompNamesCategory) {
            return ((AbstractCompNamesCategory)element).getName();
        }
        if (element instanceof IComponentNamePO) {
            IComponentNamePO cName = (IComponentNamePO)element;
            String cType = CompSystemI18n.getString((String)cName.getComponentType());
            String displayName = String.valueOf(cName.getName()) + " " + "[" + cType + "]";
            return displayName;
        }
        if (element instanceof IPersistentObject) {
            IPersistentObject node = (IPersistentObject)element;
            if (node.getName() != null) {
                return node.getName();
            }
            return node.toString();
        }
        Assert.notReached((String)(String.valueOf(Messages.UnknownTypeOfElementInTreeOfType) + " " + element.getClass().getName()));
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IComponentNamePO) {
            return IconConstants.LOGICAL_NAME_IMAGE;
        }
        if (element instanceof IReusedProjectPO) {
            return IconConstants.PROJECT_IMAGE;
        }
        if (element instanceof AbstractCompNamesCategory) {
            return IconConstants.CATEGORY_IMAGE;
        }
        return super.getImage(element);
    }

    public TreeViewer getViewer() {
        return this.m_viewer;
    }

    private void setViewer(TreeViewer viewer) {
        this.m_viewer = viewer;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        IProjectPO cp = GeneralStorage.getInstance().getProject();
        if (cp != null) {
            AbstractCompNamesCategory ac;
            if (element instanceof IComponentNamePO && cp.getId().equals(((IComponentNamePO)element).getParentProjectId())) {
                return null;
            }
            if ((element instanceof UsedCompnamesCategory || element instanceof UnusedCompnamesCategory) && (ac = (AbstractCompNamesCategory)element).getParentProjectID() == cp.getId().longValue()) {
                return null;
            }
        }
        return DISABLED_COLOR;
    }

    public abstract class AbstractCompNamesCategory {
        private String m_name;
        private long m_parentProjectID;
        private Object m_parent;

        public boolean equals(Object obj) {
            if (obj instanceof AbstractCompNamesCategory) {
                AbstractCompNamesCategory sg = (AbstractCompNamesCategory)obj;
                return new EqualsBuilder().append((Object)this.m_name, (Object)sg.getName()).append(this.m_parent, sg.getParent()).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_name).append(this.m_parent).toHashCode();
        }

        public Object getParent() {
            return this.m_parent;
        }

        public void setParent(Object parent) {
            this.m_parent = parent;
        }

        public long getParentProjectID() {
            return this.m_parentProjectID;
        }

        public void setParentProjectID(long parentProjectID) {
            this.m_parentProjectID = parentProjectID;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }
    }

    public class ReusedCompnamesCategory
    extends AbstractCompNamesCategory {
        public ReusedCompnamesCategory(long parentID, Object parent) {
            this.setName(org.eclipse.jubula.client.ui.rcp.i18n.Messages.CompNameBrowserReusedCat);
            this.setParentProjectID(parentID);
            this.setParent(parent);
        }
    }

    public class UnusedCompnamesCategory
    extends AbstractCompNamesCategory {
        public UnusedCompnamesCategory(long parentID, Object parent) {
            this.setName(org.eclipse.jubula.client.ui.rcp.i18n.Messages.CompNameBrowserUnusedCat);
            this.setParentProjectID(parentID);
            this.setParent(parent);
        }
    }

    public class UsedCompnamesCategory
    extends AbstractCompNamesCategory {
        public UsedCompnamesCategory(long parentID, Object parent) {
            this.setName(org.eclipse.jubula.client.ui.rcp.i18n.Messages.CompNameBrowserUsedCat);
            this.setParentProjectID(parentID);
            this.setParent(parent);
        }
    }
}

