/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.validator.cell;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class PortCellEditorValidator
implements ICellEditorValidator {
    private String[] m_i18nArguments;

    public PortCellEditorValidator(String cellName) {
        Validate.notNull((Object)cellName);
        this.m_i18nArguments = new String[]{cellName};
    }

    public String isValid(Object value) {
        try {
            int portValue = Integer.parseInt(ObjectUtils.toString((Object)value));
            if (portValue < 1024 || portValue > 65535) {
                return NLS.bind((String)Messages.ValidationPortErrorInvalidPortNumber, (Object[])this.m_i18nArguments);
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return NLS.bind((String)Messages.ValidationPortErrorInvalidPortNumber, (Object[])this.m_i18nArguments);
        }
    }
}

