/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import org.apache.commons.lang.builder.EqualsBuilder;

public class ClickOptions {
    private int m_clickCount = 1;
    private boolean m_scrollToVisible = true;
    private ClickType m_clickType = ClickType.CLICKED;
    private boolean m_isMoveInSteps = true;
    private boolean m_confirmClick = true;
    private int m_mouseButton = 1;
    private ClickModifier m_clickModifier = ClickModifier.create();

    public static ClickOptions create() {
        return new ClickOptions();
    }

    public int getClickCount() {
        return this.m_clickCount;
    }

    public ClickType getClickType() {
        return this.m_clickType;
    }

    public boolean isScrollToVisible() {
        return this.m_scrollToVisible;
    }

    public ClickOptions setClickCount(int clickCount) {
        this.m_clickCount = clickCount;
        return this;
    }

    public ClickOptions setClickType(ClickType clickType) {
        this.m_clickType = clickType;
        return this;
    }

    public ClickOptions setScrollToVisible(boolean scrollToVisible) {
        this.m_scrollToVisible = scrollToVisible;
        return this;
    }

    public String toString() {
        String clickType = this.m_clickType == ClickType.CLICKED ? "CLICKED" : "RELEASED";
        String str = String.valueOf(this.getClass().getName()) + " ClickCount: " + this.m_clickCount + " ClickType: " + clickType;
        return str;
    }

    public ClickOptions setStepMovement(boolean isMoveInSteps) {
        this.m_isMoveInSteps = isMoveInSteps;
        return this;
    }

    public boolean getStepMovement() {
        return this.m_isMoveInSteps;
    }

    public ClickOptions setConfirmClick(boolean confirmClick) {
        this.m_confirmClick = confirmClick;
        return this;
    }

    public boolean isConfirmClick() {
        return this.m_confirmClick;
    }

    public ClickOptions setMouseButton(int mouseButton) {
        this.m_mouseButton = mouseButton;
        return this;
    }

    public ClickOptions left() {
        return this.setMouseButton(1);
    }

    public int getMouseButton() {
        return this.m_mouseButton;
    }

    public ClickOptions setClickModifier(ClickModifier clickModifier) {
        this.m_clickModifier = clickModifier;
        return this;
    }

    public ClickModifier getClickModifier() {
        return this.m_clickModifier;
    }

    public static class ClickModifier {
        public static final int NO_MODIFIER = 0;
        public static final int M1 = 1;
        public static final int M2 = 2;
        public static final int M3 = 4;
        public static final int M4 = 8;
        private int m_bitmask = 0;

        private ClickModifier(int bitmask) {
            this.m_bitmask = bitmask;
        }

        public static ClickModifier create(int bitmask) {
            return new ClickModifier(bitmask);
        }

        public static ClickModifier create() {
            return ClickModifier.create(0);
        }

        public boolean hasModifiers(int mod) {
            return new EqualsBuilder().append(this.m_bitmask & mod, mod).isEquals();
        }

        public ClickModifier add(int bitmask) {
            this.m_bitmask |= bitmask;
            return this;
        }
    }

    public static class ClickType {
        public static final ClickType CLICKED = new ClickType();
        public static final ClickType RELEASED = new ClickType();

        private ClickType() {
        }
    }
}

