/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import java.awt.Point;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;

public class MouseMovementStrategy {
    private MouseMovementStrategy() {
    }

    public static Point[] getMovementPath(Point from, Point to, boolean isMoveInSteps) {
        Validate.notNull((Object)from, (String)"Initial point must not be null.");
        Validate.notNull((Object)to, (String)"End point must not be null.");
        Validate.isTrue((to.x >= 0 ? 1 : 0) != 0, (String)"End x-coordinate must not be negative.");
        Validate.isTrue((to.y >= 0 ? 1 : 0) != 0, (String)"End y-coordinate must not be negative.");
        Validate.isTrue((from.x >= 0 ? 1 : 0) != 0, (String)"Initial x-coordinate must not be negative.");
        Validate.isTrue((from.y >= 0 ? 1 : 0) != 0, (String)"Initial y-coordinate must not be negative.");
        if (!isMoveInSteps) {
            return new Point[]{new Point(to.x - 1, to.y - 1), to};
        }
        ArrayList<Point> path = new ArrayList<Point>();
        int[] xCoords = MouseMovementStrategy.getMovementPath(from.x, to.x);
        int[] yCoords = MouseMovementStrategy.getMovementPath(from.y, to.y);
        int i = 0;
        while (i < xCoords.length) {
            path.add(new Point(xCoords[i], from.y));
            ++i;
        }
        i = 0;
        while (i < yCoords.length) {
            path.add(new Point(to.x, yCoords[i]));
            ++i;
        }
        if (path.isEmpty() || !to.equals(path.get(path.size() - 1))) {
            path.add(new Point(to));
        }
        return path.toArray(new Point[path.size()]);
    }

    private static int[] getMovementPath(int from, int to) {
        int diff = to - from;
        int direction = diff != 0 ? diff / Math.abs(diff) : 1;
        int current = from;
        int[] retVal = new int[Math.abs(diff)];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = current += direction;
            ++i;
        }
        return retVal;
    }
}

