/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.constants.TimingConstantsServer;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class RobotTiming
extends TimingConstantsServer {
    private static final String EXTERNAL_PROPERTY_NAME_PRE_MOUSE_UP_DELAY = "TEST_DELAY_PRE_MOUSE_UP";
    private static final String EXTERNAL_PROPERTY_NAME_POST_MOUSE_UP_DELAY = "TEST_DELAY_POST_MOUSE_UP";
    private static final int NO_EXTERNAL_WAIT = -1;
    private static AutServerLogger log;
    private static int preClickDelay;
    private static int postMouseDown;
    private static int postMouseUp;
    private static int eventConfirmTimeout;
    private static long lastPerformedClick;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.driver.RobotTiming");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger(clazz);
        preClickDelay = -1;
        postMouseDown = -1;
        postMouseUp = -1;
        eventConfirmTimeout = -1;
        lastPerformedClick = -1L;
    }

    private RobotTiming() {
    }

    public static final int getEventConfirmTimeout() {
        if (eventConfirmTimeout >= 0) {
            return eventConfirmTimeout;
        }
        eventConfirmTimeout = 2000;
        return eventConfirmTimeout;
    }

    private static final int getPreClickDelay() {
        if (preClickDelay >= 0) {
            return preClickDelay;
        }
        int systemDoubleClickIntervall = EnvironmentUtils.getPlatformDoubleClickSpeed();
        preClickDelay = systemDoubleClickIntervall > 0 ? systemDoubleClickIntervall + 50 : 1000;
        return preClickDelay;
    }

    private static final int getPostMouseDownDelay() {
        if (postMouseDown >= 0) {
            return postMouseDown;
        }
        int externalWait = RobotTiming.getExternalWait(EXTERNAL_PROPERTY_NAME_PRE_MOUSE_UP_DELAY);
        if (externalWait != -1) {
            postMouseDown = externalWait;
            return postMouseDown;
        }
        postMouseDown = 50;
        return postMouseDown;
    }

    private static final int getPostMouseUpDelay() {
        if (postMouseUp >= 0) {
            return postMouseUp;
        }
        int externalWait = RobotTiming.getExternalWait(EXTERNAL_PROPERTY_NAME_POST_MOUSE_UP_DELAY);
        if (externalWait != -1) {
            postMouseUp = externalWait;
            return postMouseUp;
        }
        postMouseUp = 50;
        return postMouseUp;
    }

    private static final int getExternalWait(String propertyName) {
        int wait = -1;
        String delay = System.getProperty(propertyName);
        if (delay != null) {
            try {
                wait = new Integer(delay);
            }
            catch (NumberFormatException e) {
                log.warn("Error while parsing click delay parameter. Using default value.", e);
            }
        }
        return wait;
    }

    public static final void setPreClickDelay(int delay) {
        preClickDelay = delay;
    }

    public static final void setEventConfirmTimeout(int timeout) {
        eventConfirmTimeout = timeout < 0 ? 2000 : timeout;
    }

    public static final void sleepPreClickDelay() {
        long pcd = RobotTiming.getPreClickDelay();
        long timeDiff = System.currentTimeMillis() - lastPerformedClick;
        if (timeDiff < pcd) {
            RobotTiming.delay(pcd -= timeDiff);
        }
    }

    public static final void sleepPostMouseDownDelay() {
        RobotTiming.delay(RobotTiming.getPostMouseDownDelay());
        lastPerformedClick = System.currentTimeMillis();
    }

    public static final void sleepPostMouseUpDelay() {
        RobotTiming.delay(RobotTiming.getPostMouseUpDelay());
    }

    public static final void sleepPreShowPopupDelay() {
        RobotTiming.delay(100L);
    }

    public static final void sleepPostShowSubMenuItem() {
        RobotTiming.delay(100L);
    }

    public static final void sleepWaitForComponentPollingDelay() {
        RobotTiming.delay(100L);
    }

    public static final void sleepPostWindowActivationDelay() {
        RobotTiming.delay(200L);
    }

    private static final void delay(long timeInMilliSecs) {
        TimeUtil.delay((long)timeInMilliSecs);
    }
}

