/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses;

import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.implclasses.IComponentFactory;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class DefaultComponentFactory
implements IComponentFactory {
    private String createMessage(String componentName, Exception e) {
        return "The component '" + componentName + "' could not be instantiated:" + e.getMessage();
    }

    public Object createComponent(String componentName) throws UnsupportedComponentException {
        try {
            return Class.forName(componentName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedComponentException(this.createMessage(componentName, e), MessageIDs.E_COMPONENT_NOT_INSTANTIATED);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedComponentException(this.createMessage(componentName, e), MessageIDs.E_COMPONENT_NOT_INSTANTIATED);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedComponentException(this.createMessage(componentName, e), MessageIDs.E_COMPONENT_NOT_INSTANTIATED);
        }
    }
}

