/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;

public class KeyAcceptor {
    public static final int MAPPING_KEY_COMB = 1;
    public static final int CHECKMODE_KEY_COMB = 2;
    public static final int CHECKCOMP_KEY_COMB = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public int accept(InputEvent event) {
        int keyMod = 0;
        if (event.isAltDown()) {
            keyMod |= 0x200;
        }
        if (event.isShiftDown()) {
            keyMod |= 0x40;
        }
        if (event.isControlDown()) {
            keyMod |= 0x80;
        }
        if (event.isAltGraphDown()) {
            keyMod |= 0x2000;
        }
        int inputCode = 0;
        if (event instanceof KeyEvent) {
            inputCode = ((KeyEvent)event).getKeyCode();
        } else if (event instanceof MouseEvent) {
            int button = ((MouseEvent)event).getButton();
            switch (button) {
                case 1: {
                    inputCode = 1;
                    break;
                }
                case 2: {
                    inputCode = 2;
                    break;
                }
                case 3: {
                    inputCode = 3;
                    break;
                }
            }
        }
        if ((inputCode == AUTServerConfiguration.getInstance().getKey() || inputCode == AUTServerConfiguration.getInstance().getMouseButton()) && keyMod == AUTServerConfiguration.getInstance().getKeyMod()) {
            return 1;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckModeKey() && keyMod == AUTServerConfiguration.getInstance().getCheckModeKeyMod()) {
            return 2;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckCompKey() && keyMod == AUTServerConfiguration.getInstance().getCheckCompKeyMod()) {
            return 3;
        }
        return 0;
    }

    public boolean isSingleLineTrigger(KeyEvent event) {
        boolean isSingleTrigger = false;
        int keycode = event.getKeyCode();
        int modifier = event.getModifiers();
        SortedSet singleTrigger = AUTServerConfiguration.getInstance().getSingleLineTrigger();
        isSingleTrigger = this.isTrigger(singleTrigger, keycode, modifier);
        return isSingleTrigger;
    }

    public boolean isMultiLineTrigger(KeyEvent event) {
        boolean isMultiTrigger = false;
        int keycode = event.getKeyCode();
        int modifier = event.getModifiers();
        SortedSet multiTrigger = AUTServerConfiguration.getInstance().getMultiLineTrigger();
        isMultiTrigger = this.isTrigger(multiTrigger, keycode, modifier);
        return isMultiTrigger;
    }

    public boolean isTrigger(SortedSet triggerSet, int key, int modifiers) {
        boolean isTrigger = false;
        int triggerCode = 0;
        int triggerModMask = 0;
        Iterator it = triggerSet.iterator();
        while (it.hasNext()) {
            String trigger = it.next().toString().toUpperCase();
            if (trigger.indexOf("+") != -1) {
                String[] keys = trigger.split("\\+");
                switch (keys.length) {
                    case 2: {
                        triggerModMask = this.getModifierMask(keys[0]);
                        triggerCode = this.getKeyCode(keys[1]);
                        break;
                    }
                    case 3: {
                        triggerModMask = this.getModifierMask(keys[0]) | this.getModifierMask(keys[1]);
                        triggerCode = this.getKeyCode(keys[2]);
                        break;
                    }
                    case 4: {
                        triggerModMask = this.getModifierMask(keys[0]) | this.getModifierMask(keys[1]) | this.getModifierMask(keys[2]);
                        triggerCode = this.getKeyCode(keys[3]);
                    }
                }
            } else {
                triggerModMask = 0;
                triggerCode = this.getKeyCode(trigger);
            }
            if (key != triggerCode || modifiers != triggerModMask) continue;
            isTrigger = true;
        }
        return isTrigger;
    }

    public int getKeyCode(String keyCodeName) {
        int code = -1;
        String codeName = "VK_" + keyCodeName;
        if (codeName.equals("VK_CTRL")) {
            codeName = "VK_CONTROL";
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.event.KeyEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getField(codeName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.awt.event.KeyEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            code = field.getInt(clazz2);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return code;
    }

    public int getModifierMask(String modifierName) {
        int code = -1;
        String codeName = String.valueOf(modifierName) + "_MASK";
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.event.InputEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getField(codeName);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.awt.event.InputEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            code = field.getInt(clazz2);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return code;
    }
}

