/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.examples.wizards;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.examples.JWTExamplePlugin;
import org.eclipse.jwt.examples.l10n.Messages;
import org.eclipse.jwt.examples.wizards.JWTExample;
import org.eclipse.jwt.examples.wizards.JWTExampleWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewExampleWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private JWTExampleWizardPage jwtExamplesPage;
    private List<JWTExample> jwtExamples;
    private static final String JWT_EXAMPLES_EXTENSION_POINT_ID = "org.eclipse.jwt.JWTExample";
    public WizardNewProjectCreationPage wizardNewProjectCreationPage;
    private IConfigurationElement config;

    public NewExampleWizard() {
        this.setNeedsProgressMonitor(true);
        this.jwtExamples = new ArrayList<JWTExample>();
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(JWT_EXAMPLES_EXTENSION_POINT_ID);
        if (contributions != null) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                if (extension != null) {
                    try {
                        JWTExample jwtExample = (JWTExample)extension.createExecutableExtension("class");
                        this.jwtExamples.add(jwtExample);
                    }
                    catch (CoreException e) {
                        JWTExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jwt.examples", 4, e.getMessage(), (Throwable)e));
                    }
                }
                ++n2;
            }
        }
        Collections.sort(this.jwtExamples, new Comparator<JWTExample>(){

            @Override
            public int compare(JWTExample o1, JWTExample o2) {
                String w2;
                String w1 = o1.getTitle().split("\\s", 2)[0];
                int cmp = w1.compareTo(w2 = o2.getTitle().split("\\s", 2)[0]);
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getDifficulty() - o2.getDifficulty();
            }
        });
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Messages.monitor_creatingProject, 120);
                            IPath projectPath = NewExampleWizard.this.wizardNewProjectCreationPage.getLocationPath();
                            String projectName = NewExampleWizard.this.wizardNewProjectCreationPage.getProjectName();
                            String projectFolder = String.valueOf(projectPath.toOSString()) + File.separator + projectName;
                            File projectFolderFile = new File(projectFolder);
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IProject project = workspace.getRoot().getProject(projectName);
                            if (!project.exists()) {
                                projectFolderFile.mkdirs();
                                monitor.worked(10);
                                NewExampleWizard.this.extractProject(projectFolderFile, ((JWTExample)NewExampleWizard.this.jwtExamples.get(NewExampleWizard.this.jwtExamplesPage.getSelection())).getZipURL(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                if (projectPath.equals((Object)workspace.getRoot().getLocation())) {
                                    project.create(monitor);
                                } else {
                                    IProjectDescription desc = workspace.newProjectDescription(project.getName());
                                    desc.setLocation((IPath)new Path(projectFolder));
                                    project.create(desc, monitor);
                                }
                            }
                            project.open(monitor);
                            NewExampleWizard.this.renameProject(project, projectName);
                            monitor.worked(10);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getConfigurationElement());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception e) {
            JWTExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jwt.examples", 4, e.getMessage(), (Throwable)e));
            return false;
        }
        return true;
    }

    private void extractProject(File projectFolderFile, URL url, IProgressMonitor monitor) throws FileNotFoundException, IOException, InterruptedException {
        URL urlZipLocal = FileLocator.toFileURL((URL)url);
        ZipFile zipFile = new ZipFile(urlZipLocal.getPath());
        try {
            monitor.beginTask(Messages.monitor_unzippingProject, zipFile.size());
            this.unzip(zipFile, projectFolderFile, monitor);
        }
        finally {
            zipFile.close();
            monitor.done();
        }
    }

    private void unzip(ZipFile zipFile, File projectFolderFile, IProgressMonitor monitor) throws IOException, FileNotFoundException, InterruptedException {
        ArrayList<URI> workflows = new ArrayList<URI>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            block22: {
                ZipEntry zipEntry = e.nextElement();
                File file = new File(projectFolderFile, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    int len;
                    Object[] buffer;
                    Closeable os;
                    Closeable is;
                    Path path;
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    if ((path = new Path(file.getPath())).getFileExtension().equals("java")) {
                        is = null;
                        os = null;
                        try {
                            is = new InputStreamReader(zipFile.getInputStream(zipEntry), "ISO-8859-1");
                            os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ResourcesPlugin.getEncoding());
                            buffer = new char[102400];
                            while (true) {
                                if ((len = ((Reader)is).read((char[])buffer)) < 0) {
                                    break block22;
                                }
                                ((OutputStreamWriter)os).write((char[])buffer, 0, len);
                            }
                        }
                        finally {
                            if (is != null) {
                                ((InputStreamReader)is).close();
                            }
                            if (os != null) {
                                ((OutputStreamWriter)os).close();
                            }
                        }
                    }
                    is = null;
                    os = null;
                    try {
                        is = zipFile.getInputStream(zipEntry);
                        os = new FileOutputStream(file);
                        buffer = new byte[102400];
                        while ((len = ((InputStream)is).read((byte[])buffer)) >= 0) {
                            ((OutputStream)os).write((byte[])buffer, 0, len);
                        }
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    if (path.getFileExtension().equals("workflow")) {
                        URI fileUri = URI.createFileURI((String)file.getAbsolutePath());
                        workflows.add(fileUri);
                    }
                }
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        for (URI fileUri : workflows) {
            IEditorDescriptor editorDescriptor = null;
            try {
                editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileUri.toString());
                if (editorDescriptor == null) continue;
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(fileUri), editorDescriptor.getId());
            }
            catch (Exception exception) {}
        }
    }

    private void renameProject(IProject project, String projectName) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setName(projectName);
        project.move(description, 33, null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.jwtExamplesPage = new JWTExampleWizardPage(Messages.JWTExampleWizardPage_title, Messages.JWTExampleWizardPage_desc, JWTExamplePlugin.getImageDescriptor(Messages.JWTExampleWizardPage_icon));
        this.jwtExamplesPage.setTitle(Messages.JWTExampleWizardPage_title);
        this.jwtExamplesPage.setImageDescriptor(JWTExamplePlugin.getImageDescriptor(Messages.JWTExampleWizardPage_icon));
        this.addPage((IWizardPage)this.jwtExamplesPage);
        this.wizardNewProjectCreationPage = new WizardNewProjectCreationPage(Messages.WizardNewProjectCreationPage_pageName);
        this.wizardNewProjectCreationPage.setTitle(Messages.WizardNewProjectCreationPage_title);
        this.wizardNewProjectCreationPage.setDescription(Messages.WizardNewProjectCreationPage_desc);
        this.wizardNewProjectCreationPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.wizardNewProjectCreationPage);
    }

    public boolean canFinish() {
        return this.wizardNewProjectCreationPage.isPageComplete();
    }

    private IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    public void setInitializationData(IConfigurationElement configIn, String propertyName, Object data) throws CoreException {
        this.config = configIn;
    }

    List<JWTExample> getJWTExamples() {
        return this.jwtExamples;
    }
}

