/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.exportTransformations.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.exportTransformations.ExportJWTTransformationRequestDesc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TransformationExportWizardPage
extends WizardPage {
    private static final String PAGE_NAME = TransformationsMessages.exportWizard_pageName;
    private ExportJWTTransformationRequestDesc exportTransfoDesc;
    private String originalInFilePath;
    private boolean useCurrentModel;

    public TransformationExportWizardPage() {
        super(PAGE_NAME);
        this.setTitle(TransformationsMessages.exportWizard_pageTitle);
        this.setDescription(TransformationsMessages.exportWizard_pageDescription);
    }

    public void createControl(Composite parent) {
        if (this.getControl() == null) {
            this.exportTransfoDesc = new ExportJWTTransformationRequestDesc(parent, new CompletedPageListener());
            if (this.originalInFilePath != null) {
                this.exportTransfoDesc.setInFilePath(this.originalInFilePath);
            } else if (this.useCurrentModel) {
                this.exportTransfoDesc.useCurrentModel();
            }
            this.setControl((Control)this.exportTransfoDesc.createControl());
            this.setPageComplete(this.exportTransfoDesc.hasAllRequiredInfo());
        }
    }

    public boolean finish() {
        return this.exportTransfoDesc.apply();
    }

    public void setToExportItem(String inFilePath) {
        this.originalInFilePath = inFilePath;
    }

    public void useCurrentModel() {
        this.useCurrentModel = true;
    }

    private class CompletedPageListener
    implements Listener {
        private CompletedPageListener() {
        }

        public void handleEvent(Event event) {
            TransformationExportWizardPage.this.setPageComplete(TransformationExportWizardPage.this.exportTransfoDesc.hasAllRequiredInfo());
        }
    }
}

