/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.koneki.ldt.wizards.Messages;
import org.eclipse.koneki.ldt.wizards.pages.LuaProjectSettingsPage;

public class LuaProjectCreator
extends ProjectCreator {
    private LuaProjectSettingsPage luaProjectSettingPage;

    public LuaProjectCreator(IProjectWizard owner, LuaProjectSettingsPage locationGroup) {
        super(owner, (ILocationGroup)locationGroup);
        this.luaProjectSettingPage = locationGroup;
        ProjectCreator.ProjectCreateStep createSourceFolderStep = this.createSourceFolderStep();
        if (createSourceFolderStep != null) {
            this.addStep("finish", 0, (ProjectCreator.IProjectCreateStep)createSourceFolderStep, (IWizardPage)locationGroup);
        }
    }

    protected List<IBuildpathEntry> getDefaultBuildpathEntries() {
        ArrayList<IBuildpathEntry> buildPath = new ArrayList<IBuildpathEntry>();
        if (!this.luaProjectSettingPage.isExistingLocation()) {
            IFolder sourcefolder = this.getProject().getFolder("src");
            IBuildpathEntry newSourceEntry = DLTKCore.newSourceEntry((IPath)sourcefolder.getFullPath());
            buildPath.add(newSourceEntry);
            LuaExecutionEnvironment luaExecutionEnvironment = this.luaProjectSettingPage.getExecutionEnvironment();
            if (luaExecutionEnvironment != null) {
                IPath path = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath((LuaExecutionEnvironment)luaExecutionEnvironment);
                IBuildpathEntry newContainerEntry = DLTKCore.newContainerEntry((IPath)path);
                buildPath.add(newContainerEntry);
            }
        }
        return buildPath;
    }

    protected IBuildpathEntry[] initBuildpath(IProgressMonitor monitor) throws CoreException {
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(this.getDefaultBuildpathEntries());
        monitor.done();
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public ILocationGroup getLocationGroup() {
        return this.luaProjectSettingPage;
    }

    protected ProjectCreator.ProjectCreateStep createSourceFolderStep() {
        return new CreateDefaultSourceFolderProjectCreateStep();
    }

    private class CreateDefaultSourceFolderProjectCreateStep
    extends ProjectCreator.ProjectCreateStep {
        private CreateDefaultSourceFolderProjectCreateStep() {
        }

        public void execute(IProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
            monitor.beginTask(Messages.LuaProjectCreatorInitializingSourceFolder, 1);
            IFolder sourcefolder = project.getFolder("src");
            if (sourcefolder.exists() && !LuaProjectCreator.this.luaProjectSettingPage.isExistingLocation()) {
                byte[] bytes = "local function main()\n\nend\nmain()\n".getBytes();
                IFile mainFile = sourcefolder.getFile("main.lua");
                mainFile.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }
}

