/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core.validation;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.Messages;
import org.eclipse.libra.warproducts.core.WARProductModel;
import org.eclipse.libra.warproducts.core.WARProductUtil;
import org.eclipse.libra.warproducts.core.validation.Validation;
import org.eclipse.libra.warproducts.core.validation.ValidationError;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.product.ProductPlugin;

public class Validator {
    public static final String SERVLET_BRIDGE_ID = "org.eclipse.equinox.servletbridge";
    public static final String[] BANNED_BUNDLES = new String[]{"javax.servlet", "org.eclipse.update.configurator", "org.eclipse.equinox.http.jetty", "org.mortbay.jetty.server", "org.mortbay.jetty.util"};
    public static final String[] REQUIRED_BUNDLES = new String[]{"org.eclipse.equinox.servletbridge.extensionbundle", "org.eclipse.equinox.http.registry", "org.eclipse.equinox.registry", "org.eclipse.equinox.http.servlet", "org.eclipse.equinox.http.servletbridge"};
    private IWARProduct product;
    private Validation validation;

    public Validator(IWARProduct product) {
        this.product = product;
    }

    public Validation validate() {
        Validation result = null;
        if (this.product != null) {
            result = this.validation = new Validation();
            this.doValidation();
        }
        return result;
    }

    private void doValidation() {
        this.validateLibraries();
        this.validateBannedBundles();
        this.validateRequiredBundles();
    }

    private void validateLibraries() {
        IPath[] libraries = this.product.getLibraries();
        this.checkForServletBridge(libraries);
        this.checkLibrariesExist(libraries);
    }

    private void checkForServletBridge(IPath[] libraries) {
        if (libraries.length == 0 || !this.librariesContainsServletBridge(libraries)) {
            int type = 0;
            String message = Messages.validatorMissingLibrary;
            ValidationError error = new ValidationError(type, message, null);
            this.validation.addError(error);
        }
    }

    private boolean librariesContainsServletBridge(IPath[] libraries) {
        boolean result = false;
        int i = 0;
        while (i < libraries.length && !result) {
            IPath path = libraries[i];
            String pathString = path.toOSString();
            if (pathString.indexOf(SERVLET_BRIDGE_ID) != -1) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void checkLibrariesExist(IPath[] libraries) {
        int i = 0;
        while (i < libraries.length) {
            IPath path = WARProductUtil.getAbsolutLibraryPath(libraries[i], this.product);
            if (path != null) {
                String pathString = path.toOSString();
                File lib = new File(pathString);
                if (!lib.exists()) {
                    this.createLibraryMissingError(libraries[i]);
                }
            } else {
                this.createLibraryMissingError(libraries[i]);
            }
            ++i;
        }
    }

    private void createLibraryMissingError(IPath path) {
        int type = 1;
        String message = String.valueOf(Messages.validatorLibraryNotExist) + path + ".";
        ValidationError error = new ValidationError(type, message, path);
        this.validation.addError(error);
    }

    private void validateBannedBundles() {
        IProductPlugin[] plugins = this.product.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IProductPlugin plugin = plugins[i];
            if (this.isBundleContained(plugin.getId(), BANNED_BUNDLES)) {
                int type = 2;
                String message = String.valueOf(Messages.validatorForbiddenBundle) + plugin.getId();
                ValidationError error = new ValidationError(type, message, plugin);
                this.validation.addError(error);
            }
            ++i;
        }
    }

    private void validateRequiredBundles() {
        IProductPlugin[] bundles = this.product.getPlugins();
        String[] containedBundles = this.getBundleIdArray(bundles);
        WARProductModel fakeModel = new WARProductModel();
        int i = 0;
        while (i < REQUIRED_BUNDLES.length) {
            String bundleId = REQUIRED_BUNDLES[i];
            if (!this.isBundleContained(bundleId, containedBundles)) {
                this.createMissingBundleError(fakeModel, bundleId);
            }
            ++i;
        }
    }

    private String[] getBundleIdArray(IProductPlugin[] plugins) {
        String[] result = new String[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            result[i] = plugins[i].getId();
            ++i;
        }
        return result;
    }

    private void createMissingBundleError(WARProductModel fakeModel, String bundleId) {
        int type = 3;
        String message = String.valueOf(Messages.validatorMissingBundle) + bundleId;
        ProductPlugin missingBundle = new ProductPlugin((IProductModel)fakeModel);
        missingBundle.setId(bundleId);
        missingBundle.setVersion("0.0.0");
        ValidationError error = new ValidationError(type, message, missingBundle);
        this.validation.addError(error);
    }

    private boolean isBundleContained(String id, String[] bundleList) {
        boolean result = false;
        int i = 0;
        while (i < bundleList.length && !result) {
            String bannedId = bundleList[i];
            if (bannedId.equals(id)) {
                result = true;
            }
            ++i;
        }
        return result;
    }
}

