/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.SimpleTopic;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DevHelpTopic
implements ITopic {
    private String name;
    private XPath xpath;
    private String label;
    private List<ITopic> subTopics;

    DevHelpTopic(String name) {
        this.name = name;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.subTopics = new ArrayList<ITopic>();
        this.label = name;
        this.init();
    }

    private void init() {
        IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
        IPath devhelpLocation = new Path(ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory")).append(this.name).append(String.valueOf(this.name) + ".devhelp2");
        File devhelpFile = devhelpLocation.toFile();
        if (devhelpFile.exists()) {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setValidating(false);
            try {
                docfactory.setFeature("http://xml.org/sax/features/namespaces", false);
                docfactory.setFeature("http://xml.org/sax/features/validation", false);
                docfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                docfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
                Document docroot = docbuilder.parse(devhelpLocation.toFile());
                this.label = this.xpathEval("/book/@title", docroot);
                if (this.label.equals("")) {
                    this.label = this.name;
                }
                NodeList nodes = this.xpathEvalNodes("/book/chapters/sub", docroot);
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    this.subTopics.add(new SimpleTopic(this.name, node));
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String xpathEval(String path, Document docroot) {
        String result = "";
        try {
            result = this.xpath.evaluate(path, docroot);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private NodeList xpathEvalNodes(String path, Document docroot) {
        NodeList result = null;
        try {
            result = (NodeList)this.xpath.evaluate(path, docroot, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getSubtopics();
    }

    public String getHref() {
        return "/org.eclipse.linuxtools.cdt.libhover.devhelp/" + this.name + "/index.html";
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic[] getSubtopics() {
        return this.subTopics.toArray(new ITopic[this.subTopics.size()]);
    }
}

