/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonOptions;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

public class LaunchOptions {
    private OprofileDaemonOptions options = new OprofileDaemonOptions();

    public boolean isValid() {
        IRemoteFileProxy proxy = null;
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String fn = this.options.getKernelImageFile();
        if (fn != null && fn.length() > 0) {
            IFileStore fileStore = proxy.getResource(this.options.getKernelImageFile());
            return fileStore.fetchInfo().exists() && !fileStore.fetchInfo().isDirectory();
        }
        return true;
    }

    public void saveConfiguration(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.KERNEL_IMAGE", this.options.getKernelImageFile());
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.SEPARATE_SAMPLES", this.options.getSeparateProfilesMask());
    }

    public void loadConfiguration(ILaunchConfiguration config) {
        try {
            this.options.setKernelImageFile(config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.KERNEL_IMAGE", ""));
            this.options.setSeparateProfilesMask(config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.SEPARATE_SAMPLES", 0));
        }
        catch (CoreException coreException) {}
    }

    public OprofileDaemonOptions getOprofileDaemonOptions() {
        return this.options;
    }

    public String getKernelImageFile() {
        return this.options.getKernelImageFile();
    }

    public void setKernelImageFile(String image) {
        this.options.setKernelImageFile(image);
    }

    public int getSeparateSamples() {
        return this.options.getSeparateProfilesMask();
    }

    public void setSeparateSamples(int how) {
        this.options.setSeparateProfilesMask(how);
    }

    public String getBinaryImage() {
        return this.options.getBinaryImage();
    }

    public void setBinaryImage(String image) {
        this.options.setBinaryImage(image);
    }
}

