/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.model;

import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;

public class PMDso
extends TreeParent {
    private String path = null;
    private boolean kernel = false;

    public boolean isKernelDso() {
        return this.kernel;
    }

    public PMDso(String dsoName, boolean kernel) {
        super(dsoName, 0.0f);
        this.kernel = kernel;
    }

    public PMFile getFile(String fileName) {
        PMFile tmp = (PMFile)this.getChild(fileName);
        if (tmp == null) {
            tmp = new PMFile(fileName);
            this.addChild(tmp);
        }
        return tmp;
    }

    public void setPath(String filePath) {
        this.path = filePath;
    }

    @Override
    public String toString() {
        String prefix = "";
        if (this.getPercent() != -1.0f) {
            prefix = String.valueOf(prefix) + this.getPercent() + "% in ";
        }
        if (this.kernel) {
            prefix = String.valueOf(prefix) + "[k] ";
        }
        if (this.path != null) {
            return String.valueOf(prefix) + this.getName() + " (at " + this.path + ")";
        }
        return String.valueOf(prefix) + this.getName();
    }

    public String getPath() {
        return this.path;
    }
}

