/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.model;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMFile;

public class TreeParent {
    private String name;
    private TreeParent parent;
    private ArrayList<TreeParent> children;
    private float percent = -1.0f;

    public String getName() {
        return this.name;
    }

    public void setParent(TreeParent parent) {
        this.parent = parent;
    }

    public TreeParent getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    public Boolean equals(String s) {
        return this.getName().equals(s);
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
    }

    public TreeParent(String name) {
        this.name = name;
        this.children = new ArrayList();
    }

    public TreeParent(String name, float percent) {
        this.name = name;
        this.percent = percent;
        this.children = new ArrayList();
    }

    public void addChild(TreeParent child) {
        this.children.add(child);
        child.setParent(this);
        this.recalculatePercentage();
    }

    public TreeParent getChild(String name) {
        for (TreeParent t : this.children) {
            if (!t.equals(name).booleanValue()) continue;
            return t;
        }
        return null;
    }

    public void removeChild(TreeParent child) {
        this.children.remove(child);
        child.setParent(null);
        this.recalculatePercentage();
    }

    public TreeParent[] getChildren() {
        return this.children.toArray(new TreeParent[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void clear() {
        this.children.clear();
    }

    public void recalculatePercentage() {
        if (this.getPercent() != -1.0f && (this instanceof PMDso || this instanceof PMFile)) {
            this.percent = 0.0f;
            TreeParent[] treeParentArray = this.getChildren();
            int n = treeParentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeParent c = treeParentArray[n2];
                this.percent += c.getPercent();
                ++n2;
            }
            if (this.getParent().getPercent() != -1.0f) {
                this.getParent().recalculatePercentage();
            }
        }
    }
}

