/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.remote.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PerfLaunchConfigDelegate
extends ProfileLaunchConfigurationDelegate {
    private ConfigUtils configUtils;
    private static String OUTPUT_STR = "--output=";

    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IFileStore workingDir;
            this.configUtils = new ConfigUtils(config);
            IProject project = ConfigUtils.getProject((String)this.configUtils.getProjectName());
            if (!PerfCore.checkRemotePerfInPath(project)) {
                Status status = new Status(4, "org.eclipse.linuxtools.perf", "Error: Perf was not found on PATH");
                throw new CoreException((IStatus)status);
            }
            URI exeURI = new URI(this.configUtils.getExecutablePath());
            String configWorkingDir = this.configUtils.getWorkingDirectory();
            RemoteConnection exeRC = new RemoteConnection(exeURI);
            monitor.worked(1);
            String perfPathString = RuntimeProcessFactory.getFactory().whichCommand("perf", project);
            boolean copyExecutable = this.configUtils.getCopyExecutable();
            if (copyExecutable) {
                URI copyExeURI = new URI(this.configUtils.getCopyFromExecutablePath());
                RemoteConnection copyExeRC = new RemoteConnection(copyExeURI);
                IRemoteFileProxy copyExeRFP = copyExeRC.getRmtFileProxy();
                IFileStore copyExeFS = copyExeRFP.getResource(copyExeURI.getPath());
                IRemoteFileProxy exeRFP = exeRC.getRmtFileProxy();
                IFileStore exeFS = exeRFP.getResource(exeURI.getPath());
                IFileInfo exeFI = exeFS.fetchInfo();
                if (exeFI.isDirectory()) {
                    IPath copyExePath = Path.fromOSString((String)copyExeURI.getPath());
                    IPath newExePath = Path.fromOSString((String)exeURI.getPath()).append(copyExePath.lastSegment());
                    exeURI = new URI(exeURI.getScheme(), exeURI.getAuthority(), newExePath.toString(), exeURI.getQuery(), exeURI.getFragment());
                    exeFS = exeRFP.getResource(exeURI.getPath());
                }
                copyExeFS.copy(exeFS, 6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IPath remoteBinFile = Path.fromOSString((String)exeURI.getPath());
            if (configWorkingDir == null) {
                IPath workingDirPath = Path.fromPortableString((String)remoteBinFile.removeLastSegments(1).toOSString());
                IRemoteFileProxy workingDirRFP = exeRC.getRmtFileProxy();
                workingDir = workingDirRFP.getResource(workingDirPath.toOSString());
            } else {
                URI workingDirURI = new URI(this.configUtils.getWorkingDirectory());
                RemoteConnection workingDirRC = new RemoteConnection(workingDirURI);
                IRemoteFileProxy workingDirRFP = workingDirRC.getRmtFileProxy();
                workingDir = workingDirRFP.getResource(workingDirURI.getPath());
            }
            String[] arguments = this.getProgramArgumentsArray(config);
            ArrayList<String> command = new ArrayList<String>(4 + arguments.length);
            command.addAll(Arrays.asList(PerfCore.getRecordString(config)));
            command.add(remoteBinFile.toOSString());
            command.set(0, perfPathString);
            command.add(2, String.valueOf(OUTPUT_STR) + configWorkingDir + '/' + "perf.data");
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[command.size()]);
            Process pProxy = RuntimeProcessFactory.getFactory().exec(commandArray, this.getEnvironment(config), workingDir, project);
            MessageConsole console = new MessageConsole("Perf Console", null);
            console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            MessageConsoleStream stream = console.newMessageStream();
            if (pProxy != null) {
                BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));
                String err = error.readLine();
                while (err != null) {
                    stream.println(err);
                    err = error.readLine();
                }
                error.close();
            }
            pProxy.destroy();
            PrintStream print = null;
            if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                ConsolePlugin plugin = ConsolePlugin.getDefault();
                IConsoleManager conMan = plugin.getConsoleManager();
                IConsole[] existing = conMan.getConsoles();
                IOConsole binaryOutCons = null;
                IConsole[] iConsoleArray = existing;
                int n = existing.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole x = iConsoleArray[n2];
                    if (x.getName().contains(this.renderProcessLabel(commandArray[0]))) {
                        binaryOutCons = (IOConsole)x;
                    }
                    ++n2;
                }
                if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                    binaryOutCons = (IOConsole)existing[existing.length - 1];
                }
                if (binaryOutCons != null) {
                    IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                    print = new PrintStream((OutputStream)outputTo);
                }
                int i = 0;
                while (i < command.size()) {
                    print.print(String.valueOf((String)command.get(i)) + " ");
                    ++i;
                }
                print.println();
                print.println("Analysing recorded perf.data, please wait...");
            }
            PerfCore.Report(config, this.getEnvironment(config), Path.fromOSString((String)(String.valueOf(configWorkingDir) + '/')), monitor, null, print);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.abort(e.getLocalizedMessage(), null, 150);
        }
        catch (RemoteConnectionException e) {
            e.printStackTrace();
            this.abort(e.getLocalizedMessage(), null, 150);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.abort(e.getLocalizedMessage(), null, 150);
        }
    }

    public String generateCommand(ILaunchConfiguration config) {
        return null;
    }
}

