/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMRequest;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMResponse;

public final class ClientSession
extends Thread {
    private static ClientSession instance = null;
    private int portnumber;
    private int clientID;
    private boolean connected;
    private String hostname = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
    private int scriptnumber = 15;
    private InputStream in;
    private TreeMap<Integer, LinkedBlockingQueue<byte[]>> mbox;

    private ClientSession() {
        this.portnumber = ConsoleLogPlugin.getDefault().getPreferenceStore().getInt("port");
        this.mbox = new TreeMap();
        this.connected = this.createConnection();
        if (this.connected) {
            this.start();
        }
    }

    public synchronized boolean sendRequest(DMRequest req) {
        try {
            Socket tmp = new Socket(this.hostname, this.portnumber);
            OutputStream out = tmp.getOutputStream();
            out.write(req.getData());
            out.flush();
            out.flush();
            out.close();
            return true;
        }
        catch (UnknownHostException uhe) {
            new ErrorMessage("Unknown host!", "Check if server is running").open();
            System.err.println("Unknown host: " + uhe.getMessage());
            this.connected = false;
            return false;
        }
        catch (IOException ioe) {
            new ErrorMessage("Unable to send request!", "Check if server is running").open();
            System.err.println("Req I/O error " + ioe.getMessage());
            this.connected = false;
            return false;
        }
    }

    public DMResponse recvResponse(int scriptnum) {
        if (!this.mbox.containsKey(scriptnum)) {
            return null;
        }
        try {
            DMResponse dm = new DMResponse(this.mbox.get(scriptnum).take());
            return dm;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public byte[] recvData(int scriptnum, int size) {
        if (!this.mbox.containsKey(scriptnum)) {
            return null;
        }
        try {
            return this.mbox.get(scriptnum).take();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interruptedrecvdata");
            return null;
        }
    }

    public boolean addSubscription(int scriptnum) {
        if (this.mbox.containsKey(scriptnum)) {
            return false;
        }
        this.mbox.put(scriptnum, new LinkedBlockingQueue());
        return true;
    }

    public boolean delSubscription(int scriptnum) {
        if (!this.mbox.containsKey(scriptnum)) {
            return false;
        }
        this.mbox.get(scriptnum).clear();
        this.mbox.remove(scriptnum);
        return true;
    }

    public static synchronized ClientSession getInstance() {
        if (instance == null) {
            instance = new ClientSession();
        } else if (!ClientSession.isConnected()) {
            ClientSession.instance.connected = instance.createConnection();
            ClientSession.instance.scriptnumber = 15;
            if (ClientSession.instance.connected) {
                instance.start();
            }
        }
        return instance;
    }

    public static int getNewScriptId() {
        return ClientSession.instance.scriptnumber++;
    }

    public static boolean isConnected() {
        return ClientSession.instance.connected;
    }

    public int getcid() {
        return this.clientID;
    }

    public void run() {
        while (!Thread.interrupted()) {
            byte[] headBuffer = new byte[24];
            try {
                this.in.read(headBuffer, 0, headBuffer.length);
                DMResponse header = new DMResponse(headBuffer);
                if (!header.isValid()) continue;
                byte[] bodyBuffer = new byte[header.getsize()];
                this.in.read(bodyBuffer, 0, bodyBuffer.length);
                if (header.getsource() == 3) {
                    if (!this.mbox.containsKey(header.getscriptID())) {
                        this.mbox.put(header.getscriptID(), new LinkedBlockingQueue());
                    }
                    this.mbox.get(header.getscriptID()).put(header.tobytes());
                    this.mbox.get(header.getscriptID()).put(bodyBuffer);
                    continue;
                }
                if (!this.mbox.containsKey(header.getscriptID())) {
                    this.mbox.put(header.getscriptID(), new LinkedBlockingQueue());
                }
                this.mbox.get(header.getscriptID()).put(header.tobytes());
                this.mbox.get(header.getscriptID()).put(bodyBuffer);
            }
            catch (InterruptedException ie) {
                System.err.println("Interrupted: " + ie.getMessage());
                break;
            }
            catch (IOException ioe) {
                new ErrorMessage("I/O Error Check host!", "See stderr for more details").open();
                System.err.println("i/o error: " + ioe.getMessage());
                return;
            }
            catch (Exception e) {
                new ErrorMessage("Check if DMD is running", "See stderr for more details").open();
                System.err.println("Server terminated unexpectedly?," + e.getMessage());
                return;
            }
        }
        this.destroyConnection();
    }

    public boolean createConnection() {
        DMResponse respacket;
        DMRequest ccpacket = new DMRequest(1, 0, 0, 0);
        byte[] buffer = new byte[24];
        this.hostname = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        this.portnumber = ConsoleLogPlugin.getDefault().getPreferenceStore().getInt("port");
        OutputStream out = null;
        try {
            Socket tmp = new Socket(this.hostname, this.portnumber);
            out = tmp.getOutputStream();
            this.in = tmp.getInputStream();
            out.write(ccpacket.getData());
            out.flush();
            this.in.read(buffer, 0, buffer.length);
            respacket = new DMResponse(buffer);
        }
        catch (UnknownHostException uhe) {
            new ErrorMessage("Unknown host!", "See stderr for more details").open();
            System.err.println("Unknown host: " + uhe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            new ErrorMessage("Connection I/O error!", "See stderr for more details").open();
            System.err.println("Con I/O error: " + ioe.getMessage());
            return false;
        }
        if (!respacket.isValid()) {
            return false;
        }
        this.clientID = respacket.getclientID();
        return true;
    }

    public boolean destroyConnection() {
        DMRequest dcpacket = new DMRequest(6, 0, this.clientID, 0);
        try {
            this.sendRequest(dcpacket);
            this.in.close();
            this.connected = false;
            return true;
        }
        catch (IOException e) {
            new ErrorMessage("Connection close error!", "See stderr for more details").open();
            System.err.println("Close error: " + e.getMessage());
            return false;
        }
    }
}

