/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.structures.runnable.StreamGobbler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScpExec
implements Runnable {
    private Session session;
    private Channel channel;
    protected boolean stopped = false;
    private boolean disposed = false;
    protected StreamGobbler inputGobbler = null;
    protected StreamGobbler errorGobbler = null;
    protected ArrayList<IGobblerListener> inputListeners = new ArrayList();
    protected ArrayList<IGobblerListener> errorListeners = new ArrayList();
    private String command = "";
    public static final int ERROR_STREAM = 0;
    public static final int INPUT_STREAM = 1;

    public ScpExec(String[] cmd, String moduleName) {
        try {
            this.command = cmd[0];
            int i = 1;
            while (i < cmd.length) {
                this.command = String.valueOf(this.command) + " " + cmd[i];
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        if (this.init()) {
            Thread t = new Thread((Runnable)this, this.command);
            t.start();
        } else {
            this.stop();
        }
    }

    protected void transferListeners() {
        int i = 0;
        while (i < this.inputListeners.size()) {
            this.inputGobbler.addDataListener(this.inputListeners.get(i));
            ++i;
        }
        i = 0;
        while (i < this.errorListeners.size()) {
            this.errorGobbler.addDataListener(this.errorListeners.get(i));
            ++i;
        }
    }

    protected boolean init() {
        String user = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scpuser");
        String host = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(user, host, 22);
            this.session.setPassword(ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scppassword"));
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect();
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(this.command);
            this.channel.setInputStream(null, true);
            this.channel.setOutputStream((OutputStream)System.out, true);
            this.channel.setExtOutputStream((OutputStream)System.err, true);
            this.errorGobbler = new StreamGobbler(this.channel.getExtInputStream());
            this.inputGobbler = new StreamGobbler(this.channel.getInputStream());
            this.transferListeners();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            new ErrorMessage("Error in connection", "File Transfer failed.\n See stderr for more details").open();
            return false;
        }
    }

    @Override
    public void run() {
        try {
            this.channel.connect();
            this.errorGobbler.start();
            this.inputGobbler.start();
            while (!this.stopped) {
                if (!this.session.isConnected()) {
                    throw new RuntimeException("Connection Timed Out");
                }
                if (!this.channel.isClosed() && this.channel.getExitStatus() == -1) continue;
                this.stop();
                break;
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.errorGobbler != null) {
                this.errorGobbler.stop();
            }
            if (this.inputGobbler != null) {
                this.inputGobbler.stop();
            }
            this.channel.disconnect();
            this.session.disconnect();
        }
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void addInputStreamListener(IGobblerListener listener) {
        if (this.inputGobbler != null) {
            this.inputGobbler.addDataListener(listener);
        } else {
            this.inputListeners.add(listener);
        }
    }

    public void addErrorStreamListener(IGobblerListener listener) {
        if (this.errorGobbler != null) {
            this.errorGobbler.addDataListener(listener);
        } else {
            this.errorListeners.add(listener);
        }
    }

    public ArrayList<IGobblerListener> getInputStreamListeners() {
        if (this.inputGobbler != null) {
            return this.inputGobbler.getDataListeners();
        }
        return this.inputListeners;
    }

    public ArrayList<IGobblerListener> getErrorStreamListeners() {
        if (this.errorGobbler != null) {
            return this.errorGobbler.getDataListeners();
        }
        return this.errorListeners;
    }

    public void removeInputStreamListener(IGobblerListener listener) {
        if (this.inputGobbler != null) {
            this.inputGobbler.removeDataListener(listener);
        } else {
            this.inputListeners.remove(listener);
        }
    }

    public void removeErrorStreamListener(IGobblerListener listener) {
        if (this.errorGobbler != null) {
            this.errorGobbler.removeDataListener(listener);
        } else {
            this.errorListeners.remove(listener);
        }
    }

    public void dispose() {
        if (!this.disposed) {
            this.stop();
            this.disposed = true;
            this.inputListeners = null;
            this.errorListeners = null;
            if (this.inputGobbler != null) {
                this.inputGobbler.dispose();
            }
            this.inputGobbler = null;
            if (this.errorGobbler != null) {
                this.errorGobbler.dispose();
            }
            this.errorGobbler = null;
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }
}

