/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs;

import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectServerDialog
extends Dialog {
    private Text hostText;
    private Text userText;
    private Text passwordText;
    private Button rememberButton;
    private Button connectButton;
    private Button cancelButton;
    private boolean result;

    public SelectServerDialog(Shell parent) {
        super(parent);
    }

    public boolean open() {
        if (ConsoleLogPlugin.getDefault().getPreferenceStore().getBoolean("rememberServer")) {
            return true;
        }
        this.result = false;
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        shell.setText("Remote Server Details");
        shell.pack();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        shell.setLayout((Layout)layout);
        GridData dataLeft = new GridData();
        dataLeft.grabExcessHorizontalSpace = false;
        dataLeft.horizontalAlignment = 16384;
        Label hostLabel = new Label((Composite)shell, 0);
        hostLabel.setText("Host: ");
        hostLabel.setLayoutData((Object)dataLeft);
        GridData dataFill = new GridData();
        dataFill.grabExcessHorizontalSpace = true;
        dataFill.horizontalAlignment = 4;
        this.hostText = new Text((Composite)shell, 2052);
        this.hostText.setLayoutData((Object)dataFill);
        this.hostText.setText(ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host"));
        Label userLabel = new Label((Composite)shell, 0);
        userLabel.setText("User: ");
        userLabel.setLayoutData((Object)dataLeft);
        this.userText = new Text((Composite)shell, 2052);
        this.userText.setLayoutData((Object)dataFill);
        this.userText.setText(ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scpuser"));
        Label passwordLabel = new Label((Composite)shell, 0);
        passwordLabel.setText("Password: ");
        passwordLabel.setLayoutData((Object)dataLeft);
        this.passwordText = new Text((Composite)shell, 2052);
        this.passwordText.setEchoChar('*');
        this.passwordText.setLayoutData((Object)dataFill);
        this.passwordText.setText(ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scppassword"));
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 2;
        this.rememberButton = new Button((Composite)shell, 32);
        this.rememberButton.setLayoutData((Object)data);
        this.rememberButton.setText("Always connect to this host.");
        data = new GridData();
        data.horizontalAlignment = 131072;
        this.cancelButton = new Button((Composite)shell, 8);
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setSize(50, 100);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServerDialog.this.result = false;
                shell.dispose();
            }
        });
        data = new GridData();
        data.horizontalAlignment = 131072;
        this.connectButton = new Button((Composite)shell, 8);
        this.connectButton.setLayoutData((Object)data);
        this.connectButton.setSize(50, 100);
        this.connectButton.setText("Connect");
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleLogPlugin.getDefault().getPreferenceStore().setValue("host", SelectServerDialog.this.hostText.getText());
                ConsoleLogPlugin.getDefault().getPreferenceStore().setValue("rememberServer", SelectServerDialog.this.rememberButton.getSelection());
                ConsoleLogPlugin.getDefault().getPreferenceStore().setValue("scppassword", SelectServerDialog.this.passwordText.getText());
                ConsoleLogPlugin.getDefault().getPreferenceStore().setValue("scpuser", SelectServerDialog.this.userText.getText());
                SelectServerDialog.this.result = true;
                shell.close();
            }
        });
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }
}

