/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class ModuleView
extends ViewPart {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.ModuleView";
    protected TreeViewer viewer;

    public ModuleView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        parent.getShell().setCursor(new Cursor((Device)parent.getShell().getDisplay(), 1));
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.generateModuleTree();
        this.makeActions();
        LogManager.logDebug((String)"End createPartControl:", (Object)((Object)this));
    }

    protected abstract void generateModuleTree();

    protected void makeActions() {
    }

    public void refresh() {
        this.generateModuleTree();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
        super.dispose();
        this.viewer = null;
    }

    private static class ViewContentProvider
    implements ITreeContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object par) {
            TreeNode parent = (TreeNode)par;
            Object[] children = new Object[parent.getChildCount()];
            int i = 0;
            while (i < children.length) {
                children[i] = parent.getChildAt(i);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).getChildCount() > 0;
        }
    }

    public class ViewLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        FontRegistry registry = new FontRegistry();
        int j = 0;

        public Image getImage(Object element) {
            TreeNode treeObj = (TreeNode)element;
            Image img = null;
            img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            if (treeObj.getChildCount() == 0) {
                img = DashboardPlugin.getImageDescriptor("icons/misc/module_obj.gif").createImage();
            }
            return img;
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Font getFont(Object element) {
            Font font = Display.getCurrent().getSystemFont();
            return font;
        }

        public Color getBackground(Object element) {
            Color c = null;
            return c;
        }

        public Color getForeground(Object element, int columnIndex) {
            Color color = null;
            return color;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

