/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.dashboardextension.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.dashboardextension.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportScriptDialog
extends TitleAreaDialog {
    private IDataSet data;
    private Tree treeGraphs;
    private Text txtDisplay;
    private Text txtCategory;
    private Text txtDescription;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddFilter;
    private String display;
    private String category;
    private String description;
    private GraphData[] graphData;
    private TreeNode filters;
    private TreeItem selectedTreeItem;

    public ExportScriptDialog(Shell parentShell, IDataSet data) {
        super(parentShell);
        this.data = data;
    }

    public void create() {
        super.create();
        this.setTitle(Localization.getString("ExportScriptDialog.ExportScript"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        comp.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        Label lblDisplay = new Label(comp, 0);
        lblDisplay.setText(Localization.getString("ExportScriptDialog.Display"));
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.txtDisplay = new Text(comp, 2048);
        this.txtDisplay.setLayoutData((Object)layoutData);
        Label lblCategory = new Label(comp, 0);
        lblCategory.setText(Localization.getString("ExportScriptDialog.Category"));
        this.txtCategory = new Text(comp, 2048);
        this.txtCategory.setLayoutData((Object)layoutData);
        Label lblDescription = new Label(comp, 0);
        lblDescription.setText(Localization.getString("ExportScriptDialog.Description"));
        this.txtDescription = new Text(comp, 2114);
        this.txtDescription.setLayoutData((Object)layoutData);
        Label lblGraphs = new Label(comp, 0);
        lblGraphs.setText(Localization.getString("ExportScriptDialog.Graphs"));
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        lblGraphs.setLayoutData((Object)layoutData);
        Composite treeComposite = new Composite(comp, 0);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        treeComposite.setLayoutData((Object)layoutData);
        GridLayout treeLayout = new GridLayout();
        treeLayout.numColumns = 2;
        treeLayout.makeColumnsEqualWidth = false;
        treeComposite.setLayout((Layout)treeLayout);
        this.treeGraphs = new Tree(treeComposite, 2052);
        layoutData = new GridData();
        layoutData.verticalSpan = 3;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.treeGraphs.setLayoutData((Object)layoutData);
        Composite buttonComposite = new Composite(treeComposite, 0);
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.pack = false;
        buttonLayout.marginHeight = 5;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.btnAdd = new Button(buttonComposite, 8);
        this.btnAdd.setText(Localization.getString("ExportScriptDialog.Add"));
        this.btnAddFilter = new Button(buttonComposite, 8);
        this.btnAddFilter.setText(Localization.getString("ExportScriptDialog.AddFilter"));
        this.btnAddFilter.setEnabled(false);
        this.btnRemove = new Button(buttonComposite, 8);
        this.btnRemove.setText(Localization.getString("ExportScriptDialog.Remove"));
        this.btnRemove.setEnabled(false);
        this.treeGraphs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportScriptDialog.this.selectedTreeItem = (TreeItem)e.item;
                if (ExportScriptDialog.this.selectedTreeItem.getParentItem() == null) {
                    ExportScriptDialog.this.btnAddFilter.setEnabled(true);
                } else {
                    ExportScriptDialog.this.btnAddFilter.setEnabled(false);
                }
                ExportScriptDialog.this.btnRemove.setEnabled(true);
            }
        });
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphWizard wizard = new SelectGraphWizard(ExportScriptDialog.this.data);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    TreeItem item = new TreeItem(ExportScriptDialog.this.treeGraphs, 0);
                    item.setText(String.valueOf(GraphFactory.getGraphName((String)gd.graphID)) + ":" + gd.title);
                    item.setData((Object)gd);
                }
            }
        });
        this.btnAddFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFilterWizard wizard = new SelectFilterWizard(ExportScriptDialog.this.data.getTitles());
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                IDataSetFilter f = wizard.getFilter();
                if (f != null) {
                    TreeItem item = new TreeItem(ExportScriptDialog.this.treeGraphs.getSelection()[0], 0);
                    item.setText(AvailableFilterTypes.getFilterName((String)f.getID()));
                    item.setData((Object)f);
                }
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportScriptDialog.this.selectedTreeItem.dispose();
                ExportScriptDialog.this.btnRemove.setEnabled(false);
            }
        });
        return comp;
    }

    protected void okPressed() {
        if (this.txtDisplay.getText().length() <= 0 || this.txtCategory.getText().length() <= 0 || this.txtDescription.getText().length() <= 0 || this.treeGraphs.getItemCount() <= 0) {
            String msg = MessageFormat.format(Localization.getString("ExportScriptDialog.FillFields"), null);
            MessageDialog.openWarning((Shell)this.getShell(), (String)Localization.getString("ExportScriptDialog.Error"), (String)msg);
            return;
        }
        this.display = this.txtDisplay.getText();
        this.category = this.txtCategory.getText();
        this.description = this.txtDescription.getText();
        this.buildGraphData();
        this.buildFilterData();
        super.okPressed();
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplay() {
        return this.display;
    }

    public GraphData[] getGraphs() {
        return this.graphData;
    }

    public TreeNode getGraphFilters() {
        return this.filters;
    }

    public void dispose() {
        if (this.txtDisplay != null) {
            this.txtDisplay.dispose();
        }
        if (this.txtCategory != null) {
            this.txtCategory.dispose();
        }
        if (this.txtDescription != null) {
            this.txtDescription.dispose();
        }
        if (this.treeGraphs != null) {
            this.treeGraphs.dispose();
        }
        if (this.btnAdd != null) {
            this.btnAdd.dispose();
        }
        if (this.btnRemove != null) {
            this.btnRemove.dispose();
        }
        if (this.btnAddFilter != null) {
            this.btnAddFilter.dispose();
        }
        if (this.selectedTreeItem != null) {
            this.selectedTreeItem.dispose();
        }
        this.txtDisplay = null;
        this.txtCategory = null;
        this.txtDescription = null;
        this.treeGraphs = null;
        this.btnAdd = null;
        this.btnRemove = null;
        this.btnAddFilter = null;
        this.selectedTreeItem = null;
        this.data = null;
    }

    private void buildGraphData() {
        TreeItem[] children = this.treeGraphs.getItems();
        this.graphData = new GraphData[children.length];
        int i = 0;
        while (i < this.graphData.length) {
            this.graphData[i] = (GraphData)children[i].getData();
            ++i;
        }
    }

    private void buildFilterData() {
        TreeItem[] items = this.treeGraphs.getItems();
        this.filters = new TreeNode((Object)"", false);
        int i = 0;
        while (i < items.length) {
            TreeItem[] filterItems = items[i].getItems();
            TreeNode graphLevel = new TreeNode((Object)"graph", false);
            this.filters.add(graphLevel);
            int j = 0;
            while (j < filterItems.length) {
                graphLevel.add(new TreeNode(filterItems[j].getData(), false));
                ++j;
            }
            ++i;
        }
    }
}

