/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.MatchFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.RangeFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.SortFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.UniqueFilter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.AggregateFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.FilterWizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.MatchFilterWizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.RangeFilterWizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.SortFilterWizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.filter.UniqueFilterWizardPage;
import org.eclipse.ui.IMemento;

public final class AvailableFilterTypes {
    private static final String[] filterNames = new String[]{Localization.getString("AvailableFilterTypes.MatchFilter"), Localization.getString("AvailableFilterTypes.RangeFilter"), Localization.getString("AvailableFilterTypes.SortFilter"), Localization.getString("AvailableFilterTypes.UniqueFilter")};
    private static final String[] filterDescriptions = new String[]{Localization.getString("AvailableFilterTypes.MatchFilterDescription"), Localization.getString("AvailableFilterTypes.RangeFilterDescription"), Localization.getString("AvailableFilterTypes.SortFilterDescription"), Localization.getString("AvailableFilterTypes.UniqueFilterDescription")};
    private static final FilterWizardPage[] filterWizards = new FilterWizardPage[]{new MatchFilterWizardPage(), new RangeFilterWizardPage(), new SortFilterWizardPage(), new UniqueFilterWizardPage()};
    public static final String[] filterIDs = new String[]{"org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.MatchFilter", "org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.RangeFilter", "org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.SortFilter", "org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.UniqueFilter"};

    public static FilterWizardPage getFilterWizardPage(String id) {
        FilterWizardPage page = null;
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0 && index < filterWizards.length) {
            return filterWizards[index];
        }
        return page;
    }

    public static String getFilterName(String id) {
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0) {
            return filterNames[index];
        }
        return null;
    }

    public static String getFilterDescription(String id) {
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0) {
            return filterDescriptions[index];
        }
        return null;
    }

    public static IDataSetFilter getDataSetFilter(IMemento xml) {
        String id = xml.getID();
        int column = xml.getInteger("column");
        switch (AvailableFilterTypes.getIndex(id)) {
            case 0: {
                String val = xml.getString("value");
                int style = xml.getInteger("style");
                return new MatchFilter(column, (Object)val, style);
            }
            case 1: {
                int style = xml.getInteger("style");
                String l = xml.getString("low");
                String h = xml.getString("high");
                Number low = l.contains(".") ? (Number)Double.valueOf(l) : (Number)Long.valueOf(l);
                Number high = h.contains(".") ? (Number)Double.valueOf(h) : (Number)Long.valueOf(h);
                return new RangeFilter(column, low, high, style);
            }
            case 2: {
                int style = xml.getInteger("style");
                return new SortFilter(column, style);
            }
            case 3: {
                String agg = xml.getString("aggregate");
                int style = xml.getInteger("style");
                return new UniqueFilter(column, AggregateFactory.createAggregate(agg), style);
            }
        }
        return null;
    }

    private static int getIndex(String id) {
        int i = 0;
        while (i < filterIDs.length) {
            if (id.equals(filterIDs[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

