/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.systemtapgui.SystemTapGUIPlugin;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.PreferenceConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnvironmentVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static StringFieldEditor[] envVariables;

    public EnvironmentVariablesPreferencePage() {
        LogManager.logDebug((String)"Start EnvironmentVariablesPreferencePage:", (Object)((Object)this));
        this.setPreferenceStore(SystemTapGUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Environment Variables.");
        LogManager.logDebug((String)"End EnvironmentVariablesPreferencePage:", (Object)((Object)this));
    }

    public void init(IWorkbench workbench) {
        LogManager.logDebug((String)"Start init:", (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        LogManager.logDebug((String)"End init:", (Object)((Object)this));
    }

    protected Control createContents(Composite parent) {
        LogManager.logDebug((String)("Start createComponents: parent-" + parent), (Object)((Object)this));
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)sc, 0);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)c);
        sc.setMinSize(c.computeSize(-1, -1));
        envVariables = new StringFieldEditor[PreferenceConstants.P_ENV.length];
        int i = 0;
        while (i < envVariables.length) {
            EnvironmentVariablesPreferencePage.envVariables[i] = this.createStringFieldEditor(PreferenceConstants.P_ENV[i][0], PreferenceConstants.P_ENV[i][1], c);
            ++i;
        }
        LogManager.logDebug((String)("End createComponents: returnVal-" + sc), (Object)((Object)this));
        return sc;
    }

    private StringFieldEditor createStringFieldEditor(String name, String lblText, Composite parent) {
        LogManager.logDebug((String)("Start createStringFieldEditor: name-" + name + ", lblText-" + lblText + ", parent-" + parent), (Object)((Object)this));
        StringFieldEditor sfe = new StringFieldEditor(name, lblText, parent);
        sfe.setPage((DialogPage)this);
        sfe.setPreferenceStore(this.getPreferenceStore());
        sfe.load();
        LogManager.logDebug((String)("End createStringFieldEditor: returnVal-" + sfe), (Object)((Object)this));
        return sfe;
    }

    protected void performDefaults() {
        LogManager.logDebug((String)"Start performDefaults:", (Object)((Object)this));
        int i = 0;
        while (i < envVariables.length) {
            envVariables[i].loadDefault();
            ++i;
        }
        super.performDefaults();
        LogManager.logDebug((String)"End performDefaults:", (Object)((Object)this));
    }

    public boolean performOk() {
        LogManager.logDebug((String)"Start performOk:", (Object)((Object)this));
        int i = 0;
        while (i < envVariables.length) {
            envVariables[i].store();
            ++i;
        }
        LogManager.logDebug((String)"End performOk: returnVal-true", (Object)((Object)this));
        return true;
    }

    public static String[] getEnvironmentVariables() {
        LogManager.logDebug((String)"Start getEnvVars:", EnvironmentVariablesPreferencePage.class);
        ArrayList<String> vars = new ArrayList<String>();
        String[] envVars = null;
        if (SystemTapGUIPlugin.getDefault() == null || SystemTapGUIPlugin.getDefault().getPreferenceStore() == null) {
            return null;
        }
        IPreferenceStore p = SystemTapGUIPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PreferenceConstants.P_ENV.length) {
            String var = p.getString(PreferenceConstants.P_ENV[i][0]).trim();
            if (!var.equals("")) {
                vars.add(String.valueOf(PreferenceConstants.P_ENV[i][0]) + "=" + var);
            }
            ++i;
        }
        if (vars.size() > 0) {
            envVars = new String[vars.size()];
            i = 0;
            while (i < vars.size()) {
                envVars[i] = (String)vars.get(i);
                ++i;
            }
        }
        LogManager.logDebug((String)("End getEnvVars: returnVal-" + envVars), EnvironmentVariablesPreferencePage.class);
        return envVars;
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        int i = 0;
        while (i < envVariables.length) {
            envVariables[i].dispose();
            EnvironmentVariablesPreferencePage.envVariables[i] = null;
            ++i;
        }
        envVariables = null;
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }
}

