/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfLightweightContext;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class CtfTmfTrace
extends TmfTrace<CtfTmfEvent>
implements ITmfEventParser<CtfTmfEvent> {
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    protected IStateSystemQuerier ss = null;
    private CTFTrace fTrace;

    @Override
    public void initTrace(IResource resource, String path, Class<CtfTmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            CtfIteratorManager.addTrace(this);
            CtfTmfLightweightContext ctx = new CtfTmfLightweightContext(this);
            ctx.setLocation(new CtfLocation(0L));
            if (ctx.getLocation().equals(CtfIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                ITmfTimestamp curTime = ctx.getCurrentEvent().getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
        this.buildStateSystem();
        if (resource != null) {
            try {
                resource.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new TmfTraceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public synchronized void dispose() {
        CtfIteratorManager.removeTrace(this);
        super.dispose();
    }

    @Override
    public boolean validate(IProject project, String path) {
        try {
            CTFTrace temp = new CTFTrace(path);
            return temp.majortIsSet();
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfTmfLightweightContext context = new CtfTmfLightweightContext(this);
        context.setLocation(curLocation);
        context.seek(curLocation.getLocation());
        long currentTime = (Long)context.getLocation().getLocation();
        long startTime = CtfTmfTrace.getIterator(this, context).getStartTime();
        long endTime = CtfTmfTrace.getIterator(this, context).getEndTime();
        return ((double)currentTime - (double)startTime) / (double)(endTime - startTime);
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp instanceof CtfTmfTimestamp) {
            CtfTmfLightweightContext iter = new CtfTmfLightweightContext(this);
            iter.seek(timestamp.getValue());
            return iter;
        }
        return super.seekEvent(timestamp);
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation<?> location) {
        CtfLocation currentLocation = (CtfLocation)location;
        CtfTmfLightweightContext context = new CtfTmfLightweightContext(this);
        if (currentLocation == null) {
            currentLocation = new CtfLocation(0L);
            context.setRank(0L);
        }
        if (currentLocation.getLocation() == CtfLocation.INVALID_LOCATION) {
            ((CtfTmfTimestamp)this.getEndTime()).setType(CtfTmfTimestamp.TimestampType.NANOS);
            currentLocation.setLocation(this.getEndTime().getValue() + 1L);
        }
        context.setLocation(currentLocation);
        if (context.getRank() != 0L) {
            context.setRank(-1L);
        }
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        CtfTmfLightweightContext context = new CtfTmfLightweightContext(this);
        context.seek(Math.round((double)this.getNbEvents() * ratio));
        context.setRank(-1L);
        return context;
    }

    @Override
    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfLightweightContext) {
            if (CtfLocation.INVALID_LOCATION.equals(context.getLocation().getLocation())) {
                return null;
            }
            CtfTmfLightweightContext ctfContext = (CtfTmfLightweightContext)context;
            event = ctfContext.getCurrentEvent();
            if (event != null) {
                this.updateAttributes(context, event.getTimestamp());
                ctfContext.advance();
                ctfContext.increaseRank();
            }
        }
        return event;
    }

    protected void buildStateSystem() throws TmfTraceException {
    }

    public IStateSystemQuerier getStateSystem() {
        return this.ss;
    }

    public CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    public int getNbEnvVars() {
        return this.fTrace.getEnvironment().size();
    }

    public String[] getEnvNames() {
        String[] s = new String[this.getNbEnvVars()];
        return this.fTrace.getEnvironment().keySet().toArray(s);
    }

    public String getEnvValue(String key) {
        return (String)this.fTrace.getEnvironment().get(key);
    }

    public long getOffset() {
        if (this.fTrace != null) {
            return this.fTrace.getOffset();
        }
        return 0L;
    }

    @Override
    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfLightweightContext) {
            CtfTmfLightweightContext itt = (CtfTmfLightweightContext)context.clone();
            event = itt.getCurrentEvent();
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }

    private static CtfIterator getIterator(CtfTmfTrace trace, CtfTmfLightweightContext context) {
        return CtfIteratorManager.getIterator(trace, context);
    }
}

