/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.archetype.ArchetypeUtil;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchetypeManager {
    private final Map<String, ArchetypeCatalogFactory> catalogs = new LinkedHashMap<String, ArchetypeCatalogFactory>();
    private final File configFile;
    private final ArchetypeCatalogsWriter writer;

    public ArchetypeManager(File configFile) {
        this.configFile = configFile;
        this.writer = new ArchetypeCatalogsWriter();
    }

    public Collection<ArchetypeCatalogFactory> getArchetypeCatalogs() {
        return new ArrayList<ArchetypeCatalogFactory>(this.catalogs.values());
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory != null) {
            this.catalogs.put(factory.getId(), factory);
        }
    }

    public void removeArchetypeCatalogFactory(String catalogId) {
        this.catalogs.remove(catalogId);
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String catalogId) {
        return this.catalogs.get(catalogId);
    }

    public void readCatalogs() throws IOException {
        if (this.configFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.configFile);
                Collection<ArchetypeCatalogFactory> catalogs = this.writer.readArchetypeCatalogs(is);
                Iterator<ArchetypeCatalogFactory> it = catalogs.iterator();
                while (it.hasNext()) {
                    this.addArchetypeCatalogFactory(it.next());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
    }

    public void saveCatalogs() throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.configFile);
            this.writer.writeArchetypeCatalogs(this.getArchetypeCatalogs(), os);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    public <T extends ArchetypeCatalogFactory> T findParentCatalogFactory(Archetype archetype, Class<T> type) throws CoreException {
        if (archetype != null) {
            for (ArchetypeCatalogFactory factory : this.getArchetypeCatalogs()) {
                if (!type.isAssignableFrom(factory.getClass()) || factory.getDescription() != null && factory.getDescription().startsWith("Test")) continue;
                List archetypes = factory.getArchetypeCatalog().getArchetypes();
                for (Archetype knownArchetype : archetypes) {
                    if (!ArchetypeUtil.areEqual(archetype, knownArchetype)) continue;
                    return (T)factory;
                }
            }
        }
        return null;
    }

    public ArtifactRepository getArchetypeRepository(Archetype archetype) throws CoreException {
        ArchetypeCatalogFactory.RemoteCatalogFactory catalogFactory;
        String repoUrl = archetype.getRepository();
        if (repoUrl == null && (catalogFactory = this.findParentCatalogFactory(archetype, ArchetypeCatalogFactory.RemoteCatalogFactory.class)) != null) {
            repoUrl = catalogFactory.getRepositoryUrl();
        }
        return repoUrl == null ? null : MavenPlugin.getMaven().createArtifactRepository(String.valueOf(archetype.getArtifactId()) + "-repo", repoUrl);
    }

    public List<?> getRequiredProperties(Archetype archetype, ArtifactRepository remoteArchetypeRepository, IProgressMonitor monitor) throws UnknownArchetype, CoreException {
        Assert.isNotNull((Object)archetype, (String)"Archetype can not be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String groupId = archetype.getGroupId();
        String artifactId = archetype.getArtifactId();
        String version = archetype.getVersion();
        IMaven maven = MavenPlugin.getMaven();
        ArtifactRepository localRepository = maven.getLocalRepository();
        List<ArtifactRepository> repositories = remoteArchetypeRepository == null ? maven.getArtifactRepositories() : Collections.singletonList(remoteArchetypeRepository);
        MavenSession session = maven.createSession(maven.createExecutionRequest(monitor), null);
        MavenSession oldSession = MavenPluginActivator.getDefault().setSession(session);
        ArchetypeArtifactManager aaMgr = MavenPluginActivator.getDefault().getArchetypeArtifactManager();
        List properties = null;
        try {
            if (aaMgr.isFileSetArchetype(groupId, artifactId, version, null, localRepository, repositories)) {
                ArchetypeDescriptor descriptor = aaMgr.getFileSetArchetypeDescriptor(groupId, artifactId, version, null, localRepository, repositories);
                properties = descriptor.getRequiredProperties();
            }
        }
        finally {
            MavenPluginActivator.getDefault().setSession(oldSession);
        }
        return properties;
    }
}

