/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.maven.cli.MavenCli;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenEmbeddedRuntime
implements MavenRuntime {
    private static final String MAVEN_CORE_POM_PROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(MavenEmbeddedRuntime.class);
    private static final String MAVEN_MAVEN_EMBEDDER_BUNDLE_ID = "org.eclipse.m2e.maven.runtime";
    private static final String MAVEN_EXECUTOR_CLASS = MavenCli.class.getName();
    public static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static String[] LAUNCHER_CLASSPATH;
    private static String[] CLASSPATH;
    private static volatile String mavenVersion;
    private BundleContext bundleContext;

    public MavenEmbeddedRuntime(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getLocation() {
        return "EMBEDDED";
    }

    @Override
    public String getSettings() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void createLauncherConfiguration(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        String entry;
        collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
        this.initClasspath(this.findMavenEmbedderBundle());
        collector.addRealm("]launcher");
        String[] stringArray = LAUNCHER_CLASSPATH;
        int n = LAUNCHER_CLASSPATH.length;
        int n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            collector.addArchiveEntry(entry);
            ++n2;
        }
        collector.addRealm(PLEXUS_CLASSWORLD_NAME);
        stringArray = CLASSPATH;
        n = CLASSPATH.length;
        n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            if (!entry.contains("plexus-build-api")) {
                collector.addArchiveEntry(entry);
            }
            ++n2;
        }
    }

    private synchronized void initClasspath(Bundle mavenRuntimeBundle) {
        if (CLASSPATH == null) {
            LinkedHashSet<String> allentries = new LinkedHashSet<String>();
            this.addBundleClasspathEntries(allentries, mavenRuntimeBundle);
            State state = Platform.getPlatformAdmin().getState(false);
            BundleDescription description = state.getBundle(mavenRuntimeBundle.getBundleId());
            String[] stringArray = new String[]{"com.ning.async-http-client", "org.jboss.netty", "org.slf4j.api"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sname = stringArray[n2];
                Bundle dependency = this.findDependencyBundle(description, sname, new HashSet<BundleDescription>());
                if (dependency != null) {
                    this.addBundleClasspathEntries(allentries, dependency);
                } else {
                    log.warn("Could not find OSGi bundle with symbolic name ''{}'' required to launch embedded maven runtime in external process", (Object)sname);
                }
                ++n2;
            }
            ArrayList<String> cp = new ArrayList<String>();
            ArrayList<String> lcp = new ArrayList<String>();
            for (String entry : allentries) {
                if (entry.contains("plexus-classworlds")) {
                    lcp.add(entry);
                    continue;
                }
                cp.add(entry);
            }
            CLASSPATH = cp.toArray(new String[cp.size()]);
            LAUNCHER_CLASSPATH = lcp.toArray(new String[lcp.size()]);
        }
    }

    private Bundle findDependencyBundle(BundleDescription bundleDescription, String dependencyName, Set<BundleDescription> visited) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.addAll(Arrays.asList(bundleDescription.getRequiredBundles()));
        dependencies.addAll(Arrays.asList(bundleDescription.getImportPackages()));
        for (VersionConstraint versionConstraint : dependencies) {
            BundleDescription requiredDescription = this.getDependencyBundleDescription(versionConstraint);
            if (requiredDescription == null || !visited.add(requiredDescription)) continue;
            if (dependencyName.equals(requiredDescription.getName())) {
                return this.bundleContext.getBundle(requiredDescription.getBundleId());
            }
            Bundle required = this.findDependencyBundle(requiredDescription, dependencyName, visited);
            if (required == null) continue;
            return required;
        }
        return null;
    }

    private BundleDescription getDependencyBundleDescription(VersionConstraint requiredSpecification) {
        BaseDescription supplier = requiredSpecification.getSupplier();
        if (supplier instanceof BundleDescription) {
            return (BundleDescription)supplier;
        }
        if (supplier instanceof ExportPackageDescription) {
            return ((ExportPackageDescription)supplier).getExporter();
        }
        return null;
    }

    private void addBundleClasspathEntries(Set<String> entries, Bundle bundle) {
        log.debug("addBundleClasspathEntries(Bundle={})", (Object)bundle.toString());
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (DevClassPathHelper.inDevelopmentMode()) {
            cp.addAll(Arrays.asList(DevClassPathHelper.getDevClassPath((String)bundle.getSymbolicName())));
        }
        cp.addAll(Arrays.asList(this.parseBundleClasspath(bundle)));
        for (String cpe : cp) {
            String entry = ".".equals(cpe) ? this.getNestedJarOrDir(bundle, "/") : this.getNestedJarOrDir(bundle, cpe);
            if (entry == null) continue;
            log.debug("\tEntry:{}", (Object)entry);
            entries.add(entry);
        }
    }

    private String[] parseBundleClasspath(Bundle bundle) {
        String[] result = new String[]{"."};
        String header = (String)bundle.getHeaders().get("Bundle-ClassPath");
        ManifestElement[] classpathEntries = null;
        try {
            classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)header);
        }
        catch (BundleException ex) {
            log.warn("Could not parse bundle classpath of {}", (Object)bundle.toString(), (Object)ex);
        }
        if (classpathEntries != null) {
            result = new String[classpathEntries.length];
            int i = 0;
            while (i < classpathEntries.length) {
                result[i] = classpathEntries[i].getValue();
                ++i;
            }
        }
        return result;
    }

    private String getNestedJarOrDir(Bundle bundle, String cp) {
        File file;
        URL url = bundle.getEntry(cp);
        if (url != null) {
            try {
                return FileLocator.toFileURL((URL)url).getFile();
            }
            catch (IOException ex) {
                log.warn("Could not get entry {} for bundle {}", new Object[]{cp, bundle.toString(), ex});
            }
        }
        if (DevClassPathHelper.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        log.debug("Bundle {} does not have entry {}", (Object)bundle.toString(), (Object)cp);
        return null;
    }

    private Bundle findMavenEmbedderBundle() {
        Bundle bundle = null;
        Bundle[] bundles = this.bundleContext.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (MAVEN_MAVEN_EMBEDDER_BUNDLE_ID.equals(bundles[i].getSymbolicName())) {
                bundle = bundles[i];
                break;
            }
            ++i;
        }
        return bundle;
    }

    public String toString() {
        Bundle embedder = Platform.getBundle((String)MAVEN_MAVEN_EMBEDDER_BUNDLE_ID);
        StringBuilder sb = new StringBuilder();
        sb.append("Embedded (").append(this.getVersion());
        if (embedder != null) {
            String version = (String)embedder.getHeaders().get("Bundle-Version");
            sb.append('/').append(version);
        }
        sb.append(')');
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized String getVersion(Bundle bundle) {
        if (MavenEmbeddedRuntime.mavenVersion != null) {
            return MavenEmbeddedRuntime.mavenVersion;
        }
        this.initClasspath(bundle);
        try {
            mavenCoreJarPath = null;
            var6_4 = MavenEmbeddedRuntime.CLASSPATH;
            var5_6 = MavenEmbeddedRuntime.CLASSPATH.length;
            var4_10 = 0;
            while (var4_10 < var5_6) {
                path = var6_4[var4_10];
                if (path.contains("maven-core")) {
                    mavenCoreJarPath = path;
                    break;
                }
                ++var4_10;
            }
            if (mavenCoreJarPath == null) {
                throw new RuntimeException("Could not find maven core jar file");
            }
            pomProperties = new Properties();
            mavenCoreJar = new File(mavenCoreJarPath);
            if (mavenCoreJar.isFile()) {
                zip = new ZipFile(mavenCoreJarPath);
                try {
                    zipEntry = zip.getEntry("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                    if (zipEntry == null) ** GOTO lbl38
                    pomProperties.load(zip.getInputStream(zipEntry));
                }
                finally {
                    zip.close();
                }
            } else if (mavenCoreJar.isDirectory()) {
                is = new BufferedInputStream(new FileInputStream(new File(mavenCoreJar, "META-INF/maven/org.apache.maven/maven-core/pom.properties")));
                try {
                    pomProperties.load(is);
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
            }
            if ((version = pomProperties.getProperty("version")) != null) {
                MavenEmbeddedRuntime.mavenVersion = version;
                return MavenEmbeddedRuntime.mavenVersion;
            }
        }
        catch (Exception e) {
            MavenEmbeddedRuntime.log.warn("Could not determine embedded maven version", (Throwable)e);
        }
        return Messages.MavenEmbeddedRuntime_unknown;
    }

    @Override
    public String getVersion() {
        Bundle bundle = this.findMavenEmbedderBundle();
        return this.getVersion(bundle);
    }
}

