/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

public class MavenWorkspaceRuntime
implements MavenRuntime {
    private static final ArtifactKey MAVEN_DISTRIBUTION = new ArtifactKey("org.apache.maven", "apache-maven", "[3.0,)", null);
    private static final ArtifactKey PLEXUS_CLASSWORLDS = new ArtifactKey("org.codehaus.plexus", "plexus-classworlds", null, null);
    private static final String MAVEN_EXECUTOR_CLASS = "org.apache.maven.cli.MavenCli";
    private static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private IMavenProjectRegistry projectManager;

    public MavenWorkspaceRuntime(IMavenProjectRegistry projectManager) {
        this.projectManager = projectManager;
    }

    public String getLocation() {
        return "WORKSPACE";
    }

    public String getSettings() {
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isAvailable() {
        return this.getMavenDistribution() != null;
    }

    private IMavenProjectFacade getMavenDistribution() {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)MAVEN_DISTRIBUTION.getVersion());
            IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                ArtifactKey artifactKey = facade.getArtifactKey();
                if (MAVEN_DISTRIBUTION.getGroupId().equals(artifactKey.getGroupId()) && MAVEN_DISTRIBUTION.getArtifactId().equals(artifactKey.getArtifactId()) && range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifactKey.getVersion()))) {
                    return facade;
                }
                ++n2;
            }
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {}
        return null;
    }

    public void createLauncherConfiguration(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            MavenProject mavenProject = maven.getMavenProject(monitor);
            collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
            collector.addRealm(PLEXUS_CLASSWORLD_NAME);
            Set artifacts = mavenProject.getArtifacts();
            Artifact launcherArtifact = null;
            for (Artifact artifact : artifacts) {
                if ("test".equals(artifact.getScope())) continue;
                if (PLEXUS_CLASSWORLDS.getGroupId().equals(artifact.getGroupId()) && PLEXUS_CLASSWORLDS.getArtifactId().equals(artifact.getArtifactId())) {
                    launcherArtifact = artifact;
                    continue;
                }
                this.addArtifact(collector, artifact);
            }
            if (launcherArtifact != null) {
                collector.addRealm("]launcher");
                this.addArtifact(collector, launcherArtifact);
            }
        }
    }

    private void addArtifact(IMavenLauncherConfiguration collector, Artifact artifact) throws CoreException {
        IMavenProjectFacade facade = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (facade != null) {
            collector.addProjectEntry(facade);
        } else {
            File file = artifact.getFile();
            if (file != null) {
                collector.addArchiveEntry(file.getAbsolutePath());
            }
        }
    }

    public String toString() {
        return "Workspace (" + this.getVersion() + ")";
    }

    public String getVersion() {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            return maven.getArtifactKey().getVersion();
        }
        return MAVEN_DISTRIBUTION.getVersion();
    }
}

