/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.filter.IArtifactFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactFilterManager {
    private static final Logger log = LoggerFactory.getLogger(ArtifactFilterManager.class);

    public IStatus filter(IProject project, ArtifactKey artifact) {
        for (IArtifactFilter filter : this.getFilters()) {
            IStatus status = filter.filter(project, artifact);
            if (status == null || !status.matches(4)) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private List<IArtifactFilter> getFilters() {
        ArrayList<IArtifactFilter> filters = new ArrayList<IArtifactFilter>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint filtersExtensionPoint = registry.getExtensionPoint("org.eclipse.m2e.core.artifactFilters");
        if (filtersExtensionPoint != null) {
            IExtension[] filtersExtensions;
            IExtension[] iExtensionArray = filtersExtensions = filtersExtensionPoint.getExtensions();
            int n = filtersExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("artifactFilter".equals(element.getName())) {
                        try {
                            filters.add((IArtifactFilter)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.warn("Could not instantiate extension", (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return filters;
    }
}

