/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.SearchExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIndex
implements IIndex {
    private List<IIndex> indexes;

    public CompositeIndex(List<IIndex> indexes) {
        this.indexes = indexes;
    }

    @Override
    public IndexedArtifactFile getIndexedArtifactFile(ArtifactKey artifact) throws CoreException {
        for (IIndex index : this.indexes) {
            IndexedArtifactFile aif = index.getIndexedArtifactFile(artifact);
            if (aif == null) continue;
            return aif;
        }
        return null;
    }

    @Override
    public IndexedArtifactFile identify(File file) throws CoreException {
        List<IndexedArtifactFile> aifs = this.identifyAll(file);
        return !aifs.isEmpty() ? aifs.get(0) : null;
    }

    public List<IndexedArtifactFile> identifyAll(File file) throws CoreException {
        ArrayList<IndexedArtifactFile> result = new ArrayList<IndexedArtifactFile>();
        for (IIndex index : this.indexes) {
            IndexedArtifactFile aif = index.identify(file);
            if (aif == null) continue;
            result.add(aif);
        }
        return result;
    }

    @Override
    public Collection<IndexedArtifact> find(SearchExpression groupId, SearchExpression artifactId, SearchExpression version, SearchExpression packaging) throws CoreException {
        TreeSet<IndexedArtifact> result = new TreeSet<IndexedArtifact>();
        for (IIndex index : this.indexes) {
            Collection<IndexedArtifact> findResults = index.find(groupId, artifactId, version, packaging);
            if (findResults == null) continue;
            result.addAll(findResults);
        }
        return result;
    }

    @Override
    public Collection<IndexedArtifact> find(Collection<SearchExpression> groupId, Collection<SearchExpression> artifactId, Collection<SearchExpression> version, Collection<SearchExpression> packaging) throws CoreException {
        TreeSet<IndexedArtifact> result = new TreeSet<IndexedArtifact>();
        for (IIndex index : this.indexes) {
            Collection<IndexedArtifact> findResults = index.find(groupId, artifactId, version, packaging);
            if (findResults == null) continue;
            result.addAll(findResults);
        }
        return result;
    }

    @Override
    public Map<String, IndexedArtifact> search(SearchExpression term, String searchType) throws CoreException {
        TreeMap<String, IndexedArtifact> result = new TreeMap<String, IndexedArtifact>();
        for (IIndex index : this.indexes) {
            Map<String, IndexedArtifact> iresult = index.search(term, searchType);
            if (iresult == null) continue;
            result.putAll(iresult);
        }
        return result;
    }

    @Override
    public Map<String, IndexedArtifact> search(SearchExpression term, String searchType, int classifier) throws CoreException {
        TreeMap<String, IndexedArtifact> result = new TreeMap<String, IndexedArtifact>();
        for (IIndex index : this.indexes) {
            Map<String, IndexedArtifact> iresult = index.search(term, searchType, classifier);
            if (iresult == null) continue;
            result.putAll(iresult);
        }
        return result;
    }
}

