/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.preferences;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConfigurationImpl
implements IMavenConfiguration,
IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    private final IPreferencesService preferenceStore;
    private final ListenerList listeners = new ListenerList(1);

    public MavenConfigurationImpl() {
        this.preferenceStore = Platform.getPreferencesService();
        this.init();
    }

    private boolean exists(IEclipsePreferences preferenceNode) {
        if (preferenceNode == null) {
            return false;
        }
        try {
            return preferenceNode.nodeExists("");
        }
        catch (BackingStoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private void init() {
        if (this.exists(this.preferencesLookup[0])) {
            ((IEclipsePreferences)this.preferencesLookup[0].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[0].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[0] = new InstanceScope().getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.exists(this.preferencesLookup[1])) {
            ((IEclipsePreferences)this.preferencesLookup[1].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[1].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[1] = new DefaultScope().getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
    }

    public String getGlobalSettingsFile() {
        return this.preferenceStore.get("eclipse.m2.globalSettingsFile", null, (Preferences[])this.preferencesLookup);
    }

    public String getUserSettingsFile() {
        return this.preferenceStore.get("eclipse.m2.userSettingsFile", null, (Preferences[])this.preferencesLookup);
    }

    public boolean isDebugOutput() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.debugOutput", null, (Preferences[])this.preferencesLookup));
    }

    public void setDebugOutput(boolean debug) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.debugOutput", debug);
    }

    public boolean isDownloadJavaDoc() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.downloadJavadoc", null, (Preferences[])this.preferencesLookup));
    }

    public boolean isDownloadSources() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.downloadSources", null, (Preferences[])this.preferencesLookup));
    }

    public void setDownloadSources(boolean downloadSources) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.downloadSources", downloadSources);
    }

    public boolean isHideFoldersOfNestedProjects() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.hideFoldersOfNestedProjects", null, (Preferences[])this.preferencesLookup));
    }

    public boolean isOffline() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.offline", null, (Preferences[])this.preferencesLookup));
    }

    public void setUserSettingsFile(String settingsFile) throws CoreException {
        this.preferencesLookup[0].put("eclipse.m2.userSettingsFile", MavenConfigurationImpl.nvl(settingsFile));
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    public void setGlobalSettingsFile(String globalSettingsFile) throws CoreException {
        this.preferencesLookup[0].put("eclipse.m2.globalSettingsFile", MavenConfigurationImpl.nvl(globalSettingsFile));
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }

    private static String nvl(String s) {
        return s == null ? "" : s;
    }

    public boolean isUpdateProjectsOnStartup() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.updateProjects", null, (Preferences[])this.preferencesLookup));
    }

    public boolean isUpdateIndexesOnStartup() {
        return Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.updateIndexes", null, (Preferences[])this.preferencesLookup));
    }

    public synchronized void addConfigurationChangeListener(IMavenConfigurationChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        MavenConfigurationChangeEvent mavenEvent = new MavenConfigurationChangeEvent(event.getKey(), event.getNewValue(), event.getOldValue());
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IMavenConfigurationChangeListener)listener).mavenConfigurationChange(mavenEvent);
            }
            catch (Exception e) {
                log.error("Could not deliver maven configuration change event", (Throwable)e);
            }
            ++n2;
        }
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
        if (event.getChild() == this.preferencesLookup[0] || event.getChild() == this.preferencesLookup[1]) {
            this.init();
        }
    }

    private IPreferenceFilter getPreferenceFilter() {
        return new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "default"};
            }

            public Map getMapping(String scope) {
                return null;
            }
        };
    }

    public String getGlobalUpdatePolicy() {
        boolean never = Boolean.parseBoolean(this.preferenceStore.get("eclipse.m2.globalUpdatePolicy", null, (Preferences[])this.preferencesLookup));
        return never ? "never" : null;
    }

    public void setGlobalUpdatePolicy(String policy) {
        if (policy == null) {
            this.preferencesLookup[0].putBoolean("eclipse.m2.globalUpdatePolicy", false);
        } else if ("never".equals(policy)) {
            this.preferencesLookup[0].putBoolean("eclipse.m2.globalUpdatePolicy", true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getWorkspaceLifecycleMappingMetadataFile() {
        IPath stateLocation = MavenPluginActivator.getDefault().getStateLocation();
        String defaultValue = stateLocation.append("lifecycle-mapping-metadata.xml").toString();
        return this.preferenceStore.get("eclipse.m2.WorkspacelifecycleMappingsLocation", defaultValue, (Preferences[])this.preferencesLookup);
    }

    public void setWorkspaceLifecycleMappingMetadataFile(String location) throws CoreException {
        this.preferencesLookup[0].put("eclipse.m2.WorkspacelifecycleMappingsLocation", MavenConfigurationImpl.nvl(location));
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], new IPreferenceFilter[]{this.getPreferenceFilter()});
    }
}

