/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Icon(value="/META-INF/icons/heapobjects/classloader_obj.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingclassloader.html")
public class ClassLoaderExplorerQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public boolean tree;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> classes;
        Object obj;
        int n;
        HashMapIntObject classLoader = new HashMapIntObject();
        SetInt roots = new SetInt();
        if (this.objects != null) {
            for (int[] ia : this.objects) {
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                int[] nArray = ia;
                n = ia.length;
                int n2 = 0;
                while (n2 < n) {
                    int objectId = nArray[n2];
                    if (this.snapshot.isClassLoader(objectId)) {
                        roots.add(objectId);
                    } else if (this.snapshot.isClass(objectId)) {
                        IClass clazz = (IClass)this.snapshot.getObject(objectId);
                        roots.add(clazz.getClassLoaderId());
                    } else {
                        obj = this.snapshot.getObject(objectId);
                        IClass clazz = obj.getClazz();
                        roots.add(clazz.getClassLoaderId());
                    }
                    ++n2;
                }
            }
        }
        if ((classes = this.snapshot.getClassesByName("java.lang.ClassLoader", true)) != null) {
            for (IClass clazz : classes) {
                obj = clazz.getObjectIds();
                int n3 = ((int[])obj).length;
                n = 0;
                while (n < n3) {
                    int objectId = obj[n];
                    classLoader.put(objectId, (Object)new Node(objectId));
                    ++n;
                }
            }
        }
        for (IClass clazz : this.snapshot.getClasses()) {
            this.addClass((HashMapIntObject<Node>)classLoader, clazz);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator iter = classLoader.values();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.definedClasses != null) {
                Collections.sort(node.definedClasses, new Comparator<IClass>(){

                    @Override
                    public int compare(IClass o1, IClass o2) {
                        int n2;
                        int n1 = o1.getNumberOfObjects();
                        if (n1 > (n2 = o2.getNumberOfObjects())) {
                            return -1;
                        }
                        if (n1 < n2) {
                            return 1;
                        }
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            IClassLoader cl = (IClassLoader)this.snapshot.getObject(node.classLoaderId);
            node.name = cl.getClassSpecificName();
            if (node.name == null) {
                node.name = cl.getTechnicalName();
            }
            IObject parent = (IObject)cl.resolveValue("parent");
            boolean showNode = true;
            if (parent != null) {
                Node parentNode = (Node)classLoader.get(parent.getObjectId());
                if (!this.tree) {
                    node.parent = parentNode;
                }
                if (this.tree && parentNode != null) {
                    if (parentNode.children == null) {
                        parentNode.children = new ArrayList<Node>();
                    }
                    parentNode.children.add(node);
                    showNode = false;
                }
            }
            if (!(this.objects == null ? showNode : roots.contains(node.classLoaderId))) continue;
            nodes.add(node);
        }
        return new Result(this.snapshot, nodes);
    }

    private void addClass(HashMapIntObject<Node> classLoader, IClass clazz) {
        Node node = (Node)classLoader.get(clazz.getClassLoaderId());
        if (node == null) {
            int objectId = clazz.getClassLoaderId();
            node = new Node(objectId);
            classLoader.put(objectId, (Object)node);
        }
        if (node.definedClasses == null) {
            node.definedClasses = new ArrayList<IClass>();
        }
        node.definedClasses.add(clazz);
        node.instantiatedObjects += clazz.getNumberOfObjects();
    }

    private static class Child
    extends Parent {
        public Child(Node node) {
            super(node);
        }
    }

    private static class Node {
        Node parent;
        int classLoaderId;
        String name;
        int instantiatedObjects;
        List<IClass> definedClasses;
        List<Node> children;

        public Node(int classLoaderId) {
            this.classLoaderId = classLoaderId;
        }
    }

    private static class Parent {
        Node node;

        public Parent(Node node) {
            this.node = node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Result
    implements IResultTree,
    IIconProvider,
    IDecorator {
        ISnapshot snapshot;
        List<Node> nodes;

        public Result(ISnapshot snapshot, List<Node> nodes) {
            this.snapshot = snapshot;
            this.nodes = nodes;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider(Messages.ClassLoaderExplorerQuery_ClassLoader){

                public URL getIcon() {
                    return Icons.CLASSLOADER_INSTANCE;
                }

                public IContextObject getContext(Object row) {
                    return !(row instanceof IClass) ? Result.this.getContext(row) : null;
                }
            }).addContext(new ContextProvider(Messages.ClassLoaderExplorerQuery_Class){

                public URL getIcon() {
                    return Icons.CLASS_INSTANCE;
                }

                public IContextObject getContext(Object row) {
                    return row instanceof IClass ? Result.this.getContext(row) : null;
                }
            }).addContext(new ContextProvider(Messages.ClassLoaderExplorerQuery_DefinedClasses){

                public URL getIcon() {
                    return Icons.CLASS;
                }

                public IContextObject getContext(Object row) {
                    Node node;
                    if (row instanceof IClass) {
                        return null;
                    }
                    Node node2 = node = row instanceof Node ? (Node)row : ((Parent)row).node;
                    if (node.definedClasses == null) {
                        return null;
                    }
                    return new IContextObjectSet(){

                        public int getObjectId() {
                            return -1;
                        }

                        public int[] getObjectIds() {
                            int[] answer = new int[node.definedClasses.size()];
                            int index = 0;
                            for (IClass clazz : node.definedClasses) {
                                answer[index++] = clazz.getObjectId();
                            }
                            return answer;
                        }

                        public String getOQL() {
                            return OQL.classesByClassLoaderId(node.classLoaderId);
                        }
                    };
                }
            }).addContext(new ContextProvider(Messages.ClassLoaderExplorerQuery_Instances){

                public URL getIcon() {
                    return Icons.OBJECT_INSTANCE;
                }

                public IContextObject getContext(Object row) {
                    if (!(row instanceof IClass)) {
                        return null;
                    }
                    final IClass clazz = (IClass)row;
                    if (clazz.getNumberOfObjects() == 0) {
                        return null;
                    }
                    return new IContextObjectSet(){

                        public int getObjectId() {
                            return clazz.getObjectId();
                        }

                        public int[] getObjectIds() {
                            try {
                                return clazz.getObjectIds();
                            }
                            catch (SnapshotException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public String getOQL() {
                            return OQL.forObjectsOfClass(clazz);
                        }
                    };
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.ClassLoaderExplorerQuery_Column_DefinedClasses, Integer.TYPE).sorting(Column.SortDirection.DESC), new Column(Messages.ClassLoaderExplorerQuery_Column_NoInstances, Integer.TYPE)};
        }

        public List<?> getElements() {
            return this.nodes;
        }

        public boolean hasChildren(Object element) {
            Node node;
            if (element instanceof IClass) {
                return false;
            }
            Node node2 = node = element instanceof Node ? (Node)element : ((Parent)element).node;
            return node.parent != null || node.definedClasses != null || node.children != null;
        }

        public List<?> getChildren(Object parent) {
            int size;
            Node node = parent instanceof Node ? (Node)parent : ((Parent)parent).node;
            int n = size = node.definedClasses != null ? node.definedClasses.size() + 1 : 1;
            if (node.children != null) {
                size += node.children.size();
            }
            ArrayList<Object> children = new ArrayList<Object>(size);
            if (node.parent != null) {
                children.add(new Parent(node.parent));
            }
            if (node.children != null) {
                for (Node n2 : node.children) {
                    children.add(new Child(n2));
                }
            }
            if (node.definedClasses != null) {
                children.addAll(node.definedClasses);
            }
            return children;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            if (row instanceof IClass) {
                IClass c = (IClass)row;
                if (columnIndex == 0) {
                    return c.getName();
                }
                if (columnIndex == 2) {
                    return c.getNumberOfObjects();
                }
            } else {
                Node n;
                Node node = n = row instanceof Node ? (Node)row : ((Parent)row).node;
                if (columnIndex == 0) {
                    return n.name;
                }
                if (columnIndex == 1) {
                    return n.definedClasses != null ? n.definedClasses.size() : 0;
                }
                if (columnIndex == 2) {
                    return n.instantiatedObjects;
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof IClass) {
                final IClass clazz = (IClass)row;
                return new IContextObject(){

                    public int getObjectId() {
                        return clazz.getObjectId();
                    }
                };
            }
            final Node node = row instanceof Node ? (Node)row : ((Parent)row).node;
            return new IContextObject(){

                public int getObjectId() {
                    return node.classLoaderId;
                }
            };
        }

        public URL getIcon(Object row) {
            Node node;
            if (row instanceof IClass) {
                return Icons.CLASS;
            }
            Node node2 = node = row instanceof Node ? (Node)row : ((Parent)row).node;
            if (row instanceof Child) {
                return Icons.inbound(this.snapshot, node.classLoaderId);
            }
            return node.parent != null ? Icons.outbound(this.snapshot, node.classLoaderId) : Icons.forObject(this.snapshot, node.classLoaderId);
        }

        public String prefix(Object row) {
            return row instanceof Parent ? "parent" : null;
        }

        public String suffix(Object row) {
            return null;
        }
    }
}

