/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram
extends HistogramRecord
implements IResultTable,
IIconProvider {
    private static final long serialVersionUID = 3L;
    private boolean isDefaultHistogram = false;
    private boolean showPlusMinus = false;
    private ArrayList<ClassHistogramRecord> classHistogramRecords;
    private ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords;
    private static final char SEPARATOR_CHAR = (char)(new DecimalFormatSymbols().getDecimalSeparator() == ',' ? 59 : 44);

    Histogram() {
    }

    public Histogram(String label, ArrayList<ClassHistogramRecord> classHistogramRecords, ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        this(label, classHistogramRecords, classLoaderHistogramRecords, numberOfObjects, usedHeapSize, retainedHeapSize, false);
    }

    public Histogram(String label, ArrayList<ClassHistogramRecord> classHistogramRecords, ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize, boolean isDefaultHistogram) {
        super(label, numberOfObjects, usedHeapSize, retainedHeapSize);
        this.classHistogramRecords = classHistogramRecords;
        this.classLoaderHistogramRecords = classLoaderHistogramRecords;
        this.isDefaultHistogram = isDefaultHistogram;
    }

    public Collection<ClassHistogramRecord> getClassHistogramRecords() {
        return this.classHistogramRecords;
    }

    public Collection<ClassLoaderHistogramRecord> getClassLoaderHistogramRecords() {
        return this.classLoaderHistogramRecords;
    }

    public Histogram diffWithBaseline(Histogram baseline) {
        ClassHistogramRecord classDifference;
        String className;
        Map<String, ClassHistogramRecord> classDifferences;
        String classLoaderName;
        int classIdBase = -1000000000;
        int classLoaderIdBase = -2000000000;
        int classIdCurrent = classIdBase;
        int classLoaderIdCurrent = classLoaderIdBase;
        HashMap classLoaderDifferences = new HashMap();
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : this.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (HashMap<String, ClassHistogramRecord>)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap<String, ClassHistogramRecord>();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(classHistogramRecord.getUsedHeapSize());
            }
        }
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : baseline.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (Map)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(-classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(-classHistogramRecord.getUsedHeapSize());
            }
        }
        HashMap<String, ClassHistogramRecord> classDiffRecordsMerged = new HashMap<String, ClassHistogramRecord>();
        ArrayList<ClassLoaderHistogramRecord> classLoaderDiffRecordsMerged = new ArrayList<ClassLoaderHistogramRecord>();
        for (Map.Entry classDifferences2 : classLoaderDifferences.entrySet()) {
            ArrayList<ClassHistogramRecord> records = new ArrayList<ClassHistogramRecord>(((Map)classDifferences2.getValue()).values().size());
            int numberOfObjects = 0;
            long usedHeapSize = 0L;
            for (ClassHistogramRecord classDifference2 : ((Map)classDifferences2.getValue()).values()) {
                ClassHistogramRecord classDifferenceMerged = (ClassHistogramRecord)classDiffRecordsMerged.get(classDifference2.getLabel());
                if (classDifferenceMerged == null) {
                    classDifferenceMerged = new ClassHistogramRecord(classDifference2.getLabel(), --classIdCurrent, 0L, 0L, 0L);
                    classDiffRecordsMerged.put(classDifference2.getLabel(), classDifferenceMerged);
                }
                classDifferenceMerged.incNumberOfObjects(classDifference2.getNumberOfObjects());
                classDifferenceMerged.incUsedHeapSize(classDifference2.getUsedHeapSize());
                records.add(classDifference2);
                numberOfObjects = (int)((long)numberOfObjects + classDifference2.getNumberOfObjects());
                usedHeapSize += classDifference2.getUsedHeapSize();
            }
            classLoaderDiffRecordsMerged.add(new ClassLoaderHistogramRecord((String)classDifferences2.getKey(), --classLoaderIdCurrent, records, numberOfObjects, usedHeapSize, 0L));
        }
        Histogram histogram = new Histogram(MessageUtil.format((String)Messages.Histogram_Difference, (Object[])new Object[]{this.getLabel(), baseline.getLabel()}), new ArrayList<ClassHistogramRecord>(classDiffRecordsMerged.values()), classLoaderDiffRecordsMerged, Math.abs(this.getNumberOfObjects() - baseline.getNumberOfObjects()), Math.abs(this.getUsedHeapSize() - baseline.getUsedHeapSize()), Math.abs(this.getRetainedHeapSize() - baseline.getRetainedHeapSize()));
        histogram.showPlusMinus = true;
        return histogram;
    }

    public Histogram intersectWithAnother(Histogram another) {
        ClassHistogramRecord classDifference;
        String className;
        Map<String, ClassHistogramRecord> classDifferences;
        String classLoaderName;
        int classIdBase = -1000000000;
        int classLoaderIdBase = -2000000000;
        int classIdCurrent = classIdBase;
        int classLoaderIdCurrent = classLoaderIdBase;
        HashMap classLoaderDifferences = new HashMap();
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : this.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (HashMap<String, ClassHistogramRecord>)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap<String, ClassHistogramRecord>();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = "Class$%" + classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(classHistogramRecord.getUsedHeapSize());
            }
        }
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : another.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (Map)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get("Class$%" + className);
                if (classDifference == null || classDifference.getNumberOfObjects() <= 0L || classDifference.getNumberOfObjects() != classHistogramRecord.getNumberOfObjects()) continue;
                classDifferences.put(className, new ClassHistogramRecord(className, --classIdCurrent, classDifference.getNumberOfObjects(), classDifference.getUsedHeapSize() + classHistogramRecord.getUsedHeapSize(), 0L));
            }
        }
        HashMap<String, ClassHistogramRecord> classDiffRecordsMerged = new HashMap<String, ClassHistogramRecord>();
        ArrayList<ClassLoaderHistogramRecord> classLoaderDiffRecordsMerged = new ArrayList<ClassLoaderHistogramRecord>();
        int numberOfObjectsOverall = 0;
        long usedHeapSizeOverall = 0L;
        for (Map.Entry classDifferences2 : classLoaderDifferences.entrySet()) {
            ArrayList<ClassHistogramRecord> records = new ArrayList<ClassHistogramRecord>(((Map)classDifferences2.getValue()).values().size());
            int numberOfObjects = 0;
            long usedHeapSize = 0L;
            for (ClassHistogramRecord classDifference2 : ((Map)classDifferences2.getValue()).values()) {
                if (classDifference2.getLabel().startsWith("Class$%")) continue;
                ClassHistogramRecord classDifferenceMerged = (ClassHistogramRecord)classDiffRecordsMerged.get(classDifference2.getLabel());
                if (classDifferenceMerged == null) {
                    classDifferenceMerged = new ClassHistogramRecord(classDifference2.getLabel(), --classIdCurrent, 0L, 0L, 0L);
                    classDiffRecordsMerged.put(classDifference2.getLabel(), classDifferenceMerged);
                }
                classDifferenceMerged.incNumberOfObjects(classDifference2.getNumberOfObjects());
                classDifferenceMerged.incUsedHeapSize(classDifference2.getUsedHeapSize());
                records.add(classDifference2);
                numberOfObjects = (int)((long)numberOfObjects + classDifference2.getNumberOfObjects());
                numberOfObjectsOverall += numberOfObjects;
                usedHeapSizeOverall += (usedHeapSize += classDifference2.getUsedHeapSize());
            }
            if (records.size() <= 0) continue;
            classLoaderDiffRecordsMerged.add(new ClassLoaderHistogramRecord((String)classDifferences2.getKey(), --classLoaderIdCurrent, records, numberOfObjects, usedHeapSize, 0L));
        }
        Histogram histogram = new Histogram(MessageUtil.format((String)Messages.Histogram_Intersection, (Object[])new Object[]{this.getLabel(), another.getLabel()}), new ArrayList<ClassHistogramRecord>(classDiffRecordsMerged.values()), classLoaderDiffRecordsMerged, numberOfObjectsOverall, usedHeapSizeOverall, 0L);
        histogram.showPlusMinus = true;
        return histogram;
    }

    public boolean isDefaultHistogram() {
        return this.isDefaultHistogram;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(MessageUtil.format((String)Messages.Histogram_Description, (Object[])new Object[]{this.label, this.classLoaderHistogramRecords != null ? this.classLoaderHistogramRecords.size() : 0, this.classHistogramRecords != null ? this.classHistogramRecords.size() : 0, this.numberOfObjects, this.usedHeapSize}));
        if (this.classHistogramRecords != null) {
            buf.append("\n\n" + Messages.Histogram_ClassStatistics + ":\n");
            buf.append(Histogram.alignRight(Messages.Column_Objects, 17));
            buf.append(Histogram.alignRight(Messages.Column_ShallowHeap, 17));
            buf.append(Histogram.alignRight(Messages.Column_RetainedHeap, 17));
            buf.append("  ");
            buf.append(Histogram.alignLeft(Messages.Column_ClassName, 0));
            buf.append("\n");
            Histogram.appendRecords(buf, this.classHistogramRecords);
        }
        if (this.classLoaderHistogramRecords != null) {
            buf.append("\n\n" + Messages.Histogram_ClassLoaderStatistics + ":\n");
            buf.append(Histogram.alignRight(Messages.Column_Objects, 17));
            buf.append(Histogram.alignRight(Messages.Column_ShallowHeap, 17));
            buf.append(Histogram.alignRight(Messages.Column_RetainedHeap, 17));
            buf.append("  ");
            buf.append(Histogram.alignLeft(Messages.Column_ClassName, 0));
            buf.append("\n");
            Histogram.appendRecords(buf, this.classLoaderHistogramRecords);
        }
        return buf.toString();
    }

    private static void appendRecords(StringBuilder summary, List<? extends HistogramRecord> records) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        for (HistogramRecord histogramRecord : records) {
            summary.append(Histogram.alignRight(formatter.format(histogramRecord.getNumberOfObjects()), 17));
            summary.append(Histogram.alignRight(formatter.format(histogramRecord.getUsedHeapSize()), 17));
            if (histogramRecord.getRetainedHeapSize() < 0L) {
                summary.append(Histogram.alignRight(">=" + formatter.format(-histogramRecord.getRetainedHeapSize()), 17));
            } else {
                summary.append(Histogram.alignRight(formatter.format(histogramRecord.getRetainedHeapSize()), 17));
            }
            summary.append("  ");
            summary.append(Histogram.alignLeft(histogramRecord.getLabel(), 0));
            summary.append("\n");
        }
    }

    private static String alignLeft(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        StringBuilder buf = new StringBuilder(length);
        int blanks = length - text.length();
        buf.append(text);
        int i = 0;
        while (i < blanks) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static String alignRight(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        StringBuilder buf = new StringBuilder(length);
        int blanks = length - text.length();
        int i = 0;
        while (i < blanks) {
            buf.append(' ');
            ++i;
        }
        buf.append(text);
        return buf.toString();
    }

    public static String generateClassHistogramRecordTextReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateHistogramRecordTextReport(new ArrayList<HistogramRecord>(histogram.getClassHistogramRecords()), comparator, new String[]{Messages.Column_ClassName, Messages.Column_Objects, Messages.Column_Heap, Messages.Column_RetainedHeap});
    }

    private static String generateHistogramRecordTextReport(List<HistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        Collections.sort(records, comparator);
        int labelLength = headers[0].length();
        int numberOfObjectsLength = headers[1].length();
        int usedHeapSizeLength = headers[2].length();
        int retainedHeapSizeLength = headers[3].length();
        for (HistogramRecord record : records) {
            if (record.getLabel().length() > labelLength) {
                labelLength = record.getLabel().length();
            }
            if (Long.toString(record.getNumberOfObjects()).length() > numberOfObjectsLength) {
                numberOfObjectsLength = Long.toString(record.getNumberOfObjects()).length();
            }
            if (Long.toString(record.getUsedHeapSize()).length() > usedHeapSizeLength) {
                usedHeapSizeLength = Long.toString(record.getUsedHeapSize()).length();
            }
            if (Long.toString(record.getRetainedHeapSize()).length() <= retainedHeapSizeLength) continue;
            retainedHeapSizeLength = Long.toString(record.getRetainedHeapSize()).length();
        }
        StringBuilder report = new StringBuilder((4 + records.size()) * (2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2 + 2));
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        report.append("| ");
        Histogram.appendStringAndFillUp(report, headers[0], ' ', labelLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[1], ' ', numberOfObjectsLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[2], ' ', usedHeapSizeLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[3], ' ', retainedHeapSizeLength);
        report.append(" |\r\n");
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        for (HistogramRecord record : records) {
            report.append("| ");
            Histogram.appendStringAndFillUp(report, record.getLabel(), ' ', labelLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getNumberOfObjects()), ' ', numberOfObjectsLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getUsedHeapSize()), ' ', usedHeapSizeLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getRetainedHeapSize()), ' ', retainedHeapSizeLength);
            report.append(" |\r\n");
        }
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        return report.toString();
    }

    public static String generateClassHistogramRecordCsvReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateHistogramRecordCsvReport(new ArrayList<ClassHistogramRecord>(histogram.getClassHistogramRecords()), comparator, new String[]{Messages.Column_ClassName, Messages.Column_Objects, Messages.Column_ShallowHeap, Messages.Column_RetainedHeap});
    }

    public static String generateClassLoaderHistogramRecordCsvReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateClassloaderHistogramCsvReport(new ArrayList<ClassLoaderHistogramRecord>(histogram.getClassLoaderHistogramRecords()), comparator, new String[]{Messages.Column_ClassLoaderName, Messages.Column_ClassName, Messages.Column_Objects, Messages.Column_ShallowHeap, Messages.Column_RetainedHeap});
    }

    private static String generateClassloaderHistogramCsvReport(List<ClassLoaderHistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        StringBuilder report = new StringBuilder((1 + records.size()) * 256);
        report.append(headers[0]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[1]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[2]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[3]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[4]);
        report.append(String.valueOf(SEPARATOR_CHAR) + "\r\n");
        Collections.sort(records, comparator);
        for (ClassLoaderHistogramRecord classloaderRecord : records) {
            Collection<ClassHistogramRecord> classRecords = classloaderRecord.getClassHistogramRecords();
            ArrayList<ClassHistogramRecord> list = new ArrayList<ClassHistogramRecord>(classRecords);
            Collections.sort(list, COMPARATOR_FOR_USEDHEAPSIZE);
            int i = list.size() - 1;
            while (i >= 0) {
                ClassHistogramRecord record = (ClassHistogramRecord)list.get(i);
                report.append(classloaderRecord.getLabel());
                report.append(SEPARATOR_CHAR);
                report.append(record.getLabel());
                report.append(SEPARATOR_CHAR);
                report.append(record.getNumberOfObjects());
                report.append(SEPARATOR_CHAR);
                report.append(record.getUsedHeapSize());
                report.append(SEPARATOR_CHAR);
                if (record.getRetainedHeapSize() < 0L) {
                    report.append(">=" + -record.getRetainedHeapSize());
                } else {
                    report.append(record.getRetainedHeapSize());
                }
                report.append(String.valueOf(SEPARATOR_CHAR) + "\r\n");
                --i;
            }
        }
        return report.toString();
    }

    private static String generateHistogramRecordCsvReport(List<ClassHistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        Collections.sort(records, comparator);
        StringBuilder report = new StringBuilder((1 + records.size()) * 256);
        report.append(headers[0]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[1]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[2]);
        report.append(SEPARATOR_CHAR);
        report.append(headers[3]);
        report.append(String.valueOf(SEPARATOR_CHAR) + "\r\n");
        for (HistogramRecord histogramRecord : records) {
            report.append(histogramRecord.getLabel());
            report.append(SEPARATOR_CHAR);
            report.append(histogramRecord.getNumberOfObjects());
            report.append(SEPARATOR_CHAR);
            report.append(histogramRecord.getUsedHeapSize());
            report.append(SEPARATOR_CHAR);
            if (histogramRecord.getRetainedHeapSize() < 0L) {
                report.append(">=" + -histogramRecord.getRetainedHeapSize());
            } else {
                report.append(histogramRecord.getRetainedHeapSize());
            }
            report.append(String.valueOf(SEPARATOR_CHAR) + "\r\n");
        }
        return report.toString();
    }

    private static void appendStringAndFillUp(StringBuilder report, String string, char character, int completeLength) {
        if (string != null) {
            report.append(string);
        }
        if (string != null) {
            completeLength -= string.length();
        }
        if (completeLength > 0) {
            int i = 0;
            while (i < completeLength) {
                report.append(character);
                ++i;
            }
        }
    }

    private static void appendPreFillAndString(StringBuilder report, String string, char character, int completeLength) {
        if (string != null) {
            completeLength -= string.length();
        }
        if (completeLength > 0) {
            int i = 0;
            while (i < completeLength) {
                report.append(character);
                ++i;
            }
        }
        if (string != null) {
            report.append(string);
        }
    }

    public ResultMetaData getResultMetaData() {
        return null;
    }

    public Column[] getColumns() {
        Column[] columns = new Column[]{new Column(Messages.Column_ClassName, String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column(Messages.Column_Objects, Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column(Messages.Column_ShallowHeap, Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        if (this.showPlusMinus) {
            DecimalFormat formatter = new DecimalFormat("+#,##0;-#,##0");
            columns[1].formatting((Format)formatter);
            columns[2].formatting((Format)formatter);
        }
        return columns;
    }

    public int getRowCount() {
        return this.classHistogramRecords.size();
    }

    public Object getRow(int rowId) {
        return this.classHistogramRecords.get(rowId);
    }

    public Object getColumnValue(Object row, int columnIndex) {
        ClassHistogramRecord record = (ClassHistogramRecord)row;
        switch (columnIndex) {
            case 0: {
                return record.getLabel();
            }
            case 1: {
                return record.getNumberOfObjects();
            }
            case 2: {
                return record.getUsedHeapSize();
            }
        }
        return null;
    }

    public IContextObject getContext(Object row) {
        final ClassHistogramRecord record = (ClassHistogramRecord)row;
        if (record.getClassId() < 0) {
            return null;
        }
        return new IContextObjectSet(){

            public int getObjectId() {
                return record.getClassId();
            }

            public int[] getObjectIds() {
                return record.getObjectIds();
            }

            public String getOQL() {
                return Histogram.this.isDefaultHistogram ? OQL.forObjectsOfClass(record.getClassId()) : null;
            }
        };
    }

    public URL getIcon(Object row) {
        return Icons.CLASS;
    }

    public IResultTree groupByClassLoader() {
        return new ClassLoaderTree(this);
    }

    public IResultTree groupByPackage() {
        return new PackageTree(this);
    }

    public IResultTree groupBySuperclass(ISnapshot snapshot) {
        return new SuperclassTree(this, snapshot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassLoaderTree
    implements IResultTree,
    IIconProvider {
        private Histogram histogram;

        public ClassLoaderTree(Histogram histogram) {
            this.histogram = histogram;
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Histogram_Column_ClassLoaderPerClass, String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column(Messages.Column_Objects, Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column(Messages.Column_ShallowHeap, Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        }

        public List<?> getElements() {
            return this.histogram.classLoaderHistogramRecords;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ClassLoaderHistogramRecord;
        }

        public List<?> getChildren(Object parent) {
            return new ArrayList<ClassHistogramRecord>(((ClassLoaderHistogramRecord)parent).getClassHistogramRecords());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            HistogramRecord record = (HistogramRecord)row;
            switch (columnIndex) {
                case 0: {
                    return record.getLabel();
                }
                case 1: {
                    return record.getNumberOfObjects();
                }
                case 2: {
                    return record.getUsedHeapSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof ClassLoaderHistogramRecord) {
                final ClassLoaderHistogramRecord record = (ClassLoaderHistogramRecord)row;
                if (record.getClassLoaderId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassLoaderId();
                    }

                    public int[] getObjectIds() {
                        try {
                            return record.getObjectIds();
                        }
                        catch (SnapshotException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public String getOQL() {
                        if (ClassLoaderTree.this.histogram.isDefaultHistogram) {
                            return OQL.classesByClassLoaderId(record.getClassLoaderId());
                        }
                        return null;
                    }
                };
            }
            if (row instanceof ClassHistogramRecord) {
                final ClassHistogramRecord record = (ClassHistogramRecord)row;
                if (record.getClassId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getObjectIds();
                    }

                    public String getOQL() {
                        if (ClassLoaderTree.this.histogram.isDefaultHistogram) {
                            return OQL.forObjectsOfClass(record.getClassId());
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        public URL getIcon(Object row) {
            return row instanceof ClassLoaderHistogramRecord ? Icons.CLASSLOADER_INSTANCE : Icons.CLASS;
        }
    }

    private static class PackageNode
    extends HistogramRecord {
        private static final long serialVersionUID = 1L;
        Map<String, PackageNode> subPackages = new HashMap<String, PackageNode>();
        List<ClassHistogramRecord> classes = new ArrayList<ClassHistogramRecord>();

        public PackageNode(String name) {
            super(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PackageTree
    implements IResultTree,
    IIconProvider {
        private Histogram histogram;
        PackageNode root;

        public PackageTree(Histogram histogram) {
            this.histogram = histogram;
            this.buildTree(histogram);
        }

        private void buildTree(Histogram histogram) {
            this.root = new PackageNode("<ROOT>");
            for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
                PackageNode current = this.root;
                String[] path = SimpleStringTokenizer.split((String)record.getLabel(), (char)'.');
                int ii = 0;
                while (ii < path.length - 1) {
                    PackageNode child = current.subPackages.get(path[ii]);
                    if (child == null) {
                        child = new PackageNode(path[ii]);
                        current.subPackages.put(path[ii], child);
                    }
                    child.incNumberOfObjects(record.numberOfObjects);
                    child.incUsedHeapSize(record.getUsedHeapSize());
                    current = child;
                    ++ii;
                }
                current.classes.add(record);
            }
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Histogram_Column_PackagePerClass, String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column(Messages.Column_Objects, Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column(Messages.Column_ShallowHeap, Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        }

        public List<?> getElements() {
            return this.getChildren(this.root);
        }

        public boolean hasChildren(Object element) {
            return element instanceof PackageNode;
        }

        public List<?> getChildren(Object parent) {
            PackageNode node = (PackageNode)parent;
            ArrayList<HistogramRecord> answer = new ArrayList<HistogramRecord>();
            answer.addAll(node.subPackages.values());
            answer.addAll(node.classes);
            return answer;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            HistogramRecord record = (HistogramRecord)row;
            switch (columnIndex) {
                case 0: {
                    int p;
                    String label = record.getLabel();
                    if (!(record instanceof PackageNode) && (p = label.lastIndexOf(46)) > 0) {
                        label = label.substring(p + 1);
                    }
                    return label;
                }
                case 1: {
                    return record.getNumberOfObjects();
                }
                case 2: {
                    return record.getUsedHeapSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof PackageNode) {
                final PackageNode node = (PackageNode)row;
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return -1;
                    }

                    public int[] getObjectIds() {
                        ArrayInt objectIds = new ArrayInt();
                        LinkedList<PackageNode> nodes = new LinkedList<PackageNode>();
                        nodes.add(node);
                        while (!nodes.isEmpty()) {
                            PackageNode n = (PackageNode)nodes.removeFirst();
                            for (ClassHistogramRecord record : n.classes) {
                                objectIds.addAll(record.getObjectIds());
                            }
                            nodes.addAll(n.subPackages.values());
                        }
                        return objectIds.toArray();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            if (row instanceof ClassHistogramRecord) {
                final ClassHistogramRecord record = (ClassHistogramRecord)row;
                if (record.getClassId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getObjectIds();
                    }

                    public String getOQL() {
                        if (PackageTree.this.histogram.isDefaultHistogram()) {
                            return OQL.forObjectsOfClass(record.getClassId());
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        public URL getIcon(Object row) {
            return row instanceof PackageNode ? Icons.PACKAGE : Icons.CLASS;
        }
    }

    private static class SuperclassNode
    extends HistogramRecord {
        private static final long serialVersionUID = 1L;
        private final int classId;
        Map<Integer, SuperclassNode> subClasses = new HashMap<Integer, SuperclassNode>();
        List<ClassHistogramRecord> classes = new ArrayList<ClassHistogramRecord>();

        public SuperclassNode(String name, int id) {
            super(name);
            this.classId = id;
        }

        public SuperclassNode(String name) {
            this(name, -1);
        }

        public boolean isSimple() {
            return this.subClasses.size() == 0 && this.classes.size() == 1;
        }

        public int getClassId() {
            return this.classId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SuperclassTree
    implements IResultTree,
    IIconProvider {
        private Histogram histogram;
        SuperclassNode root;

        public SuperclassTree(Histogram histogram, ISnapshot snapshot) {
            this.histogram = histogram;
            this.buildTree(histogram, snapshot);
        }

        private void buildTree(Histogram histogram, ISnapshot snapshot) {
            this.root = new SuperclassNode("<ROOT>");
            for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
                SuperclassNode current = this.root;
                ArrayList<IClass> l1 = new ArrayList<IClass>();
                try {
                    int classId = record.getClassId();
                    if (classId >= 0) {
                        IClass cl = (IClass)snapshot.getObject(classId);
                        while (cl != null) {
                            l1.add(cl);
                            cl = cl.getSuperClass();
                        }
                    }
                }
                catch (SnapshotException snapshotException) {}
                int i = l1.size() - 1;
                while (i >= 0) {
                    IClass superclass = (IClass)l1.get(i);
                    SuperclassNode child = current.subClasses.get(superclass.getObjectId());
                    if (child == null) {
                        child = new SuperclassNode(superclass.getName(), superclass.getObjectId());
                        current.subClasses.put(superclass.getObjectId(), child);
                    }
                    child.incNumberOfObjects(record.numberOfObjects);
                    child.incUsedHeapSize(record.getUsedHeapSize());
                    current = child;
                    --i;
                }
                current.classes.add(record);
            }
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Histogram_Column_SuperclassPerClass, String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column(Messages.Column_Objects, Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column(Messages.Column_ShallowHeap, Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        }

        public List<?> getElements() {
            return this.getChildren(this.root);
        }

        public boolean hasChildren(Object element) {
            return element instanceof SuperclassNode;
        }

        public List<?> getChildren(Object parent) {
            SuperclassNode node = (SuperclassNode)parent;
            ArrayList<HistogramRecord> answer = new ArrayList<HistogramRecord>();
            for (SuperclassNode sub : node.subClasses.values()) {
                if (sub.isSimple()) {
                    answer.add(sub.classes.get(0));
                    continue;
                }
                answer.add(sub);
            }
            answer.addAll(node.classes);
            return answer;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            HistogramRecord record = (HistogramRecord)row;
            switch (columnIndex) {
                case 0: {
                    String label = record.getLabel();
                    return label;
                }
                case 1: {
                    return record.getNumberOfObjects();
                }
                case 2: {
                    return record.getUsedHeapSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof SuperclassNode) {
                final SuperclassNode node = (SuperclassNode)row;
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return node.getClassId();
                    }

                    public int[] getObjectIds() {
                        ArrayInt objectIds = new ArrayInt();
                        LinkedList<SuperclassNode> nodes = new LinkedList<SuperclassNode>();
                        nodes.add(node);
                        while (!nodes.isEmpty()) {
                            SuperclassNode n = (SuperclassNode)nodes.removeFirst();
                            for (ClassHistogramRecord record : n.classes) {
                                objectIds.addAll(record.getObjectIds());
                            }
                            nodes.addAll(n.subClasses.values());
                        }
                        return objectIds.toArray();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            if (row instanceof ClassHistogramRecord) {
                final ClassHistogramRecord record = (ClassHistogramRecord)row;
                if (record.getClassId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getObjectIds();
                    }

                    public String getOQL() {
                        if (SuperclassTree.this.histogram.isDefaultHistogram()) {
                            return OQL.forObjectsOfClass(record.getClassId());
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        public URL getIcon(Object row) {
            return row instanceof SuperclassNode ? Icons.SUPERCLASS : Icons.CLASS;
        }
    }
}

