/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.io.PositionInputStream;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class Pass2Parser
extends AbstractParser {
    private IHprofParserHandler handler;
    private SimpleMonitor.Listener monitor;

    public Pass2Parser(IHprofParserHandler handler, SimpleMonitor.Listener monitor) {
        this.handler = handler;
        this.monitor = monitor;
    }

    public void read(File file) throws SnapshotException, IOException {
        this.in = new PositionInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
        int dumpNrToRead = this.determineDumpNumber();
        int currentDumpNr = 0;
        try {
            this.version = Pass2Parser.readVersion((InputStream)this.in);
            this.idSize = this.in.readInt();
            if (this.idSize != 4 && this.idSize != 8) {
                throw new SnapshotException(Messages.Pass1Parser_Error_SupportedDumps);
            }
            this.in.skipBytes(8);
            long fileSize = file.length();
            long curPos = this.in.position();
            while (curPos < fileSize) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(curPos / 1000L);
                int record = this.in.readUnsignedByte();
                this.in.skipBytes(4);
                long length = this.readUnsignedInt();
                if (length < 0L) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, this.in.position(), record}));
                }
                switch (record) {
                    case 12: 
                    case 28: {
                        if (dumpNrToRead == currentDumpNr) {
                            this.readDumpSegments(length);
                        } else {
                            this.in.skipBytes(length);
                        }
                        if (record != 12) break;
                        ++currentDumpNr;
                        break;
                    }
                    case 44: {
                        ++currentDumpNr;
                    }
                    default: {
                        this.in.skipBytes(length);
                    }
                }
                curPos = this.in.position();
            }
        }
        catch (Throwable throwable) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
    }

    private void readDumpSegments(long length) throws SnapshotException, IOException {
        long segmentStartPos = this.in.position();
        long segmentsEndPos = segmentStartPos + length;
        while (segmentStartPos < segmentsEndPos) {
            long workDone = segmentStartPos / 1000L;
            if (this.monitor.getWorkDone() < workDone) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(workDone);
            }
            int segmentType = this.in.readUnsignedByte();
            switch (segmentType) {
                case 5: 
                case 7: 
                case 255: {
                    this.in.skipBytes(this.idSize);
                    break;
                }
                case 1: {
                    this.in.skipBytes(this.idSize * 2);
                    break;
                }
                case 4: 
                case 6: {
                    this.in.skipBytes(this.idSize + 4);
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    this.in.skipBytes(this.idSize + 8);
                    break;
                }
                case 32: {
                    this.skipClassDump();
                    break;
                }
                case 33: {
                    this.readInstanceDump(segmentStartPos);
                    break;
                }
                case 34: {
                    this.readObjectArrayDump(segmentStartPos);
                    break;
                }
                case 35: {
                    this.readPrimitiveArrayDump(segmentStartPos);
                    break;
                }
                default: {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_InvalidHeapDumpFile, (Object[])new Object[]{segmentType, segmentStartPos}));
                }
            }
            segmentStartPos = this.in.position();
        }
    }

    private void skipClassDump() throws IOException {
        this.in.skipBytes(7 * this.idSize + 8);
        int constantPoolSize = this.in.readUnsignedShort();
        int ii = 0;
        while (ii < constantPoolSize) {
            this.in.skipBytes(2);
            this.skipValue();
            ++ii;
        }
        int numStaticFields = this.in.readUnsignedShort();
        int i = 0;
        while (i < numStaticFields) {
            this.in.skipBytes(this.idSize);
            this.skipValue();
            ++i;
        }
        int numInstanceFields = this.in.readUnsignedShort();
        this.in.skipBytes((this.idSize + 1) * numInstanceFields);
    }

    private void readInstanceDump(long segmentStartPos) throws IOException {
        long id = this.readID();
        this.in.skipBytes(4);
        long classID = this.readID();
        int bytesFollowing = this.in.readInt();
        long endPos = this.in.position() + (long)bytesFollowing;
        List<IClass> hierarchy = this.handler.resolveClassHierarchy(classID);
        ClassImpl thisClazz = (ClassImpl)hierarchy.get(0);
        IHprofParserHandler.HeapObject heapObject = new IHprofParserHandler.HeapObject(this.handler.mapAddressToId(id), id, thisClazz, thisClazz.getHeapSizePerInstance());
        heapObject.references.add(thisClazz.getObjectAddress());
        for (IClass clazz : hierarchy) {
            for (FieldDescriptor field : clazz.getFieldDescriptors()) {
                int type = field.getType();
                if (type == 2) {
                    long refId = this.readID();
                    if (refId == 0L) continue;
                    heapObject.references.add(refId);
                    continue;
                }
                this.skipValue(type);
            }
        }
        if (endPos != this.in.position()) {
            throw new IOException(MessageUtil.format((String)Messages.Pass2Parser_Error_InsufficientBytesRead, (Object[])new Object[]{segmentStartPos}));
        }
        this.handler.addObject(heapObject, segmentStartPos);
    }

    private void readObjectArrayDump(long segmentStartPos) throws IOException {
        long id = this.readID();
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.readID();
        ClassImpl arrayType = (ClassImpl)this.handler.lookupClass(arrayClassObjectID);
        if (arrayType == null) {
            throw new RuntimeException(MessageUtil.format((String)Messages.Pass2Parser_Error_HandlerMustCreateFakeClassForAddress, (Object[])new Object[]{Long.toHexString(arrayClassObjectID)}));
        }
        long usedHeapSize = this.handler.getObjectArrayHeapSize(arrayType, size);
        IHprofParserHandler.HeapObject heapObject = new IHprofParserHandler.HeapObject(this.handler.mapAddressToId(id), id, arrayType, usedHeapSize);
        heapObject.references.add(arrayType.getObjectAddress());
        heapObject.isArray = true;
        int ii = 0;
        while (ii < size) {
            long refId = this.readID();
            if (refId != 0L) {
                heapObject.references.add(refId);
            }
            ++ii;
        }
        this.handler.addObject(heapObject, segmentStartPos);
    }

    private void readPrimitiveArrayDump(long segmentStartPost) throws SnapshotException, IOException {
        long id = this.readID();
        this.in.skipBytes(4);
        int size = this.in.readInt();
        byte elementType = this.in.readByte();
        if (elementType < 4 || elementType > 11) {
            throw new SnapshotException(Messages.Pass1Parser_Error_IllegalType);
        }
        String name = IPrimitiveArray.TYPE[elementType];
        ClassImpl clazz = (ClassImpl)this.handler.lookupClassByName(name, true);
        if (clazz == null) {
            throw new RuntimeException(MessageUtil.format((String)Messages.Pass2Parser_Error_HandleMustCreateFakeClassForName, (Object[])new Object[]{name}));
        }
        long usedHeapSize = this.handler.getPrimitiveArrayHeapSize(elementType, size);
        IHprofParserHandler.HeapObject heapObject = new IHprofParserHandler.HeapObject(this.handler.mapAddressToId(id), id, clazz, usedHeapSize);
        heapObject.references.add(clazz.getObjectAddress());
        heapObject.isArray = true;
        this.handler.addObject(heapObject, segmentStartPost);
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[elementType];
        this.in.skipBytes((long)elementSize * (long)size);
    }
}

