/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.viewer;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.viewer.DerivedDataJob;
import org.eclipse.mat.ui.internal.viewer.ExportActions;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.mat.ui.util.SearchOnTyping;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.themes.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefinedResultViewer {
    protected static final int LIMIT = 25;
    protected static final int MAX_COLUMN_WIDTH = 500;
    protected static final int MIN_COLUMN_WIDTH = 90;
    protected MultiPaneEditor editor;
    protected AbstractEditorPane pane;
    protected WidgetAdapter adapter;
    protected LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected Composite control;
    protected Item[] columns;
    protected ControlEditor controlEditor;
    protected int visibleItemsEstimate;
    protected Font boldFont;
    protected Color grayColor;
    protected Color greenColor;
    protected Font[] fonts;
    protected Color[] colors;
    protected IQueryContext context;
    protected QueryResult queryResult;
    protected RefinedStructuredResult result;
    protected List<RefinedStructuredResult.DerivedDataJobDefinition> jobs;
    protected QueryContextMenu contextMenu;
    protected TotalsRow rootTotalsRow;
    protected boolean needsPacking = true;

    RefinedResultViewer(IQueryContext context, QueryResult result, RefinedStructuredResult refinedResult) {
        this.context = context;
        this.queryResult = result;
        this.result = refinedResult;
        this.jobs = new ArrayList<RefinedStructuredResult.DerivedDataJobDefinition>(refinedResult.getJobs());
    }

    public abstract void init(Composite var1, MultiPaneEditor var2, AbstractEditorPane var3);

    protected void init(WidgetAdapter viewer, Composite parent, MultiPaneEditor editor, AbstractEditorPane pane) {
        this.adapter = viewer;
        this.editor = editor;
        this.pane = pane;
        parent.setRedraw(false);
        try {
            this.control = this.adapter.createControl(parent);
            this.control.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    RefinedResultViewer.this.editor.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

                        public void run() {
                            Copy.copyToClipboard((Control)(this).RefinedResultViewer.this.control);
                        }
                    });
                    RefinedResultViewer.this.editor.getEditorSite().getActionBars().updateActionBars();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.adapter.getFont()).setStyle(1));
            this.grayColor = this.resourceManager.createColor(ColorUtil.blend((RGB)this.control.getBackground().getRGB(), (RGB)this.control.getForeground().getRGB()));
            this.greenColor = this.control.getDisplay().getSystemColor(6);
            this.createColumns();
            this.addPaintListener();
            this.addDoubleClickListener();
            this.createContextMenu();
            if (this.result.getSortColumn() >= 0) {
                this.adapter.setSortColumn(this.columns[this.result.getSortColumn()]);
                this.adapter.setSortDirection(this.result.getSortDirection().getSwtCode());
            }
            SearchOnTyping.attachTo((Control)this.control, 0);
            Rectangle bounds = parent.getParent().getBounds();
            this.visibleItemsEstimate = bounds.height == 0 && bounds.width == 0 ? 10 : Math.max((bounds.height - 10) / this.adapter.getLineHeightEstimation() - 2, 1);
            this.refresh(true);
            this.addTextEditors();
        }
        finally {
            parent.setRedraw(true);
        }
    }

    private void createColumns() {
        Column[] queryColumns = this.result.getColumns();
        int nrOfColumns = queryColumns.length;
        this.columns = new Item[nrOfColumns];
        int ii = 0;
        while (ii < nrOfColumns) {
            Column queryColumn = queryColumns[ii];
            this.columns[ii] = this.adapter.createColumn(queryColumn, ii, new ColumnSelectionListener());
            if (ii == 0) {
                this.columns[ii].addListener(11, new Listener(){

                    public void handleEvent(Event event) {
                        RefinedResultViewer.this.control.redraw();
                    }
                });
            }
            ++ii;
        }
    }

    private void addDoubleClickListener() {
        this.control.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                Item widget = (Item)event.item;
                if (widget == null) {
                    return;
                }
                Object data = widget.getData();
                if (data != null) {
                    return;
                }
                ControlItem ctrl = null;
                Item parent = RefinedResultViewer.this.adapter.getParentItem(widget);
                if (parent == null) {
                    if (RefinedResultViewer.this.adapter.indexOf(widget) != 0) {
                        ctrl = (ControlItem)RefinedResultViewer.this.control.getData("$control");
                    } else {
                        int columnIndex = 0;
                        Filter filter = RefinedResultViewer.this.result.getFilter()[columnIndex];
                        RefinedResultViewer.this.activateEditor(widget, filter, columnIndex);
                    }
                } else {
                    ctrl = (ControlItem)parent.getData("$control");
                }
                if (ctrl == null || ctrl.totals == null) {
                    return;
                }
                if (ctrl.totals.getVisibleItems() >= ctrl.totals.getNumberOfItems()) {
                    return;
                }
                RefinedResultViewer.this.doRevealChildren(parent, 25);
                event.doit = false;
            }
        });
    }

    protected abstract List<?> getElements(Object var1);

    protected abstract void configureColumns();

    protected void applyTextAndImage(Item item, Object element) {
        if (element == null) {
            return;
        }
        item.setData(element);
        this.adapter.apply(item, this.adapter.getFont());
        URL image = this.result.getIcon(element);
        if (image != null) {
            item.setImage(MemoryAnalyserPlugin.getDefault().getImage(image));
        }
        int ii = 0;
        while (ii < this.columns.length) {
            if (!this.result.isDecorated(ii)) {
                this.adapter.apply(item, ii, this.result.getFormattedColumnValue(element, ii));
            } else {
                String[] texts = new String[]{this.result.getColumns()[ii].getDecorator().prefix(element), this.result.getFormattedColumnValue(element, ii), this.result.getColumns()[ii].getDecorator().suffix(element)};
                item.setData(String.valueOf(ii), (Object)texts);
                this.adapter.apply(item, ii, this.asString(texts));
            }
            ++ii;
        }
    }

    protected void applyTotals(Item item, TotalsRow totalsRow) {
        item.setImage(MemoryAnalyserPlugin.getDefault().getImage(totalsRow.getIcon()));
        int ii = 0;
        while (ii < this.columns.length) {
            this.adapter.apply(item, ii, totalsRow.getLabel(ii));
            ++ii;
        }
        this.adapter.apply(item, this.boldFont);
        item.setData(null);
        item.setData("$control", null);
    }

    protected void applyUpdating(Item item) {
        item.setText(Messages.RefinedResultViewer_updating);
        item.setImage(MemoryAnalyserPlugin.getImage("icons/refreshing.gif"));
        item.setData(null);
        item.setData("$control", null);
    }

    protected void applyFilterData(Item item) {
        Filter[] filter = this.result.getFilter();
        int ii = 0;
        while (ii < filter.length) {
            this.applyFilterData(item, ii, filter[ii]);
            ++ii;
        }
    }

    protected void applyFilterData(Item item, int columnIndex, Filter filter) {
        if (columnIndex == 0) {
            item.setImage(MemoryAnalyserPlugin.getImage("icons/filter.gif"));
        }
        String label = filter.isActive() ? filter.getCriteria() : filter.getLabel();
        Color color = filter.isActive() ? this.greenColor : this.grayColor;
        Font font = filter.isActive() ? this.boldFont : this.adapter.getFont();
        this.adapter.apply(item, columnIndex, label, color, font);
    }

    protected String asString(String[] texts) {
        StringBuilder buf = new StringBuilder();
        int ii = 0;
        while (ii < texts.length) {
            if (texts[ii] != null) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(texts[ii]);
            }
            ++ii;
        }
        return buf.toString();
    }

    private void addPaintListener() {
        boolean isDecorated = false;
        int ii = 0;
        while (!isDecorated && ii < this.result.getColumns().length) {
            isDecorated = this.result.isDecorated(ii);
            ++ii;
        }
        if (!isDecorated) {
            return;
        }
        this.fonts = new Font[3];
        this.fonts[0] = this.boldFont;
        this.fonts[1] = this.adapter.getFont();
        this.fonts[2] = this.boldFont;
        this.colors = new Color[3];
        this.colors[0] = null;
        this.colors[1] = null;
        this.colors[2] = this.grayColor;
        this.control.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                if (!RefinedResultViewer.this.result.isDecorated(event.index)) {
                    return;
                }
                Object element = event.item.getData();
                if (element == null) {
                    return;
                }
                String[] texts = (String[])event.item.getData(String.valueOf(event.index));
                if (texts == null) {
                    return;
                }
                if (texts.length > 0) {
                    int width = 0;
                    int height = 0;
                    Image image = ((Item)event.item).getImage();
                    if (image != null) {
                        width += image.getBounds().width + 4;
                    }
                    int ii = 0;
                    while (ii < texts.length) {
                        if (texts[ii] != null) {
                            event.gc.setFont(RefinedResultViewer.this.fonts[ii]);
                            Point size = event.gc.textExtent(texts[ii]);
                            width += size.x + 4;
                            height = Math.max(event.height, size.y + 2);
                        }
                        ++ii;
                    }
                    event.width = width;
                    event.height = height;
                } else {
                    event.height = Math.max(event.height, 17);
                    event.width = 90;
                }
                event.doit = false;
            }
        });
        this.control.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (!RefinedResultViewer.this.result.isDecorated(event.index)) {
                    return;
                }
                Object element = event.item.getData();
                if (element == null) {
                    return;
                }
                String[] texts = (String[])event.item.getData(String.valueOf(event.index));
                if (texts != null) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        this.control.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (!RefinedResultViewer.this.result.isDecorated(event.index)) {
                    return;
                }
                Object element = event.item.getData();
                if (element == null) {
                    return;
                }
                String[] texts = (String[])event.item.getData(String.valueOf(event.index));
                if (texts != null) {
                    boolean isSelected;
                    boolean bl = isSelected = (event.detail & 2) != 0;
                    if (isSelected) {
                        Rectangle r = event.gc.getClipping();
                        event.gc.fillRectangle(event.x, event.y, r.width, event.height - 1);
                    }
                    int x = event.x;
                    Image image = ((Item)event.item).getImage();
                    if (image != null) {
                        event.gc.drawImage(image, event.x + 1, event.y);
                        x += image.getBounds().width + 4;
                    }
                    Color fg = event.gc.getForeground();
                    int ii = 0;
                    while (ii < texts.length) {
                        if (texts[ii] != null) {
                            event.gc.setFont(RefinedResultViewer.this.fonts[ii]);
                            if (!isSelected) {
                                event.gc.setForeground(RefinedResultViewer.this.colors[ii] != null ? RefinedResultViewer.this.colors[ii] : fg);
                            }
                            Point size = event.gc.textExtent(texts[ii]);
                            event.gc.drawText(texts[ii], x + 1, event.y + Math.max(0, (event.height - size.y) / 2), true);
                            x += size.x + 4;
                        }
                        ++ii;
                    }
                    event.gc.setForeground(fg);
                    event.doit = false;
                }
            }
        });
    }

    private void createContextMenu() {
        this.contextMenu = new QueryContextMenu(this.editor, this.queryResult){

            @Override
            protected void customMenu(PopupMenu menu, List<IContextObject> menuContext, final ContextProvider provider, String label) {
                menu.addSeparator();
                ContextDerivedData.DerivedColumn[] derivedColumnArray = RefinedResultViewer.this.context.getContextDerivedData().getDerivedColumns();
                int n = derivedColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContextDerivedData.DerivedColumn derivedColumn = derivedColumnArray[n2];
                    ContextDerivedData.DerivedOperation[] derivedOperationArray = derivedColumn.getOperations();
                    int n3 = derivedOperationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        final ContextDerivedData.DerivedOperation derivedOperation = derivedOperationArray[n4];
                        Action action = new Action(derivedOperation.getLabel()){

                            public void run() {
                                RefinedResultViewer.this.doCalculateDerivedValuesForSelection(provider, derivedOperation);
                            }
                        };
                        action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/calculator.gif"));
                        menu.add(action);
                        ++n4;
                    }
                    ++n2;
                }
            }
        };
    }

    private void addTextEditors() {
        this.controlEditor = this.adapter.createEditor();
        this.control.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                Item item = RefinedResultViewer.this.adapter.getItem(pt);
                if (item != RefinedResultViewer.this.adapter.getItem(null, 0)) {
                    return;
                }
                int columnIndex = this.getColumnIndex(item, pt);
                if (columnIndex < 0) {
                    return;
                }
                Filter filter = RefinedResultViewer.this.result.getFilter()[columnIndex];
                RefinedResultViewer.this.activateEditor(item, filter, columnIndex);
            }

            private int getColumnIndex(Item item, Point pt) {
                int ii = 0;
                while (ii < RefinedResultViewer.this.columns.length) {
                    Rectangle bounds = RefinedResultViewer.this.adapter.getBounds(item, ii);
                    if (bounds.contains(pt)) {
                        return ii;
                    }
                    ++ii;
                }
                return -1;
            }
        });
    }

    public void contributeToToolBar(IToolBarManager manager) {
        EasyToolBarDropDown calculateRetainedSizeMenu = new EasyToolBarDropDown(Messages.RefinedResultViewer_CalculateRetainedSize, MemoryAnalyserPlugin.getImageDescriptor("icons/calculator.gif"), this.editor){

            public void contribute(PopupMenu menu) {
                ArrayList<ContextProvider> providers = new ArrayList<ContextProvider>();
                List p = RefinedResultViewer.this.result.getResultMetaData().getContextProviders();
                if (p != null && !p.isEmpty()) {
                    providers.addAll(p);
                } else {
                    providers.add(RefinedResultViewer.this.queryResult.getDefaultContextProvider());
                }
                if (!providers.isEmpty()) {
                    for (ContextProvider cp : providers) {
                        PopupMenu toThisMenu = menu;
                        if (providers.size() > 1) {
                            PopupMenu subMenu = new PopupMenu(cp.getLabel());
                            menu.add(subMenu);
                            toThisMenu = subMenu;
                        }
                        this.addRetainedSizeActions(toThisMenu, cp);
                    }
                }
            }

            private void addRetainedSizeActions(PopupMenu toThisMenu, final ContextProvider cp) {
                ContextDerivedData derivedData = RefinedResultViewer.this.context.getContextDerivedData();
                if (derivedData == null) {
                    return;
                }
                ContextDerivedData.DerivedColumn[] derivedColumnArray = derivedData.getDerivedColumns();
                int n = derivedColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContextDerivedData.DerivedColumn derivedColumn = derivedColumnArray[n2];
                    ContextDerivedData.DerivedOperation[] derivedOperationArray = derivedColumn.getOperations();
                    int n3 = derivedOperationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        final ContextDerivedData.DerivedOperation derivedOperation = derivedOperationArray[n4];
                        Action action = new Action(derivedOperation.getLabel()){

                            public void run() {
                                RefinedResultViewer.this.doCalculateDerivedValuesForAll(cp, derivedOperation);
                            }
                        };
                        action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/calculator.gif"));
                        toThisMenu.add(action);
                        ++n4;
                    }
                    ++n2;
                }
            }
        };
        EasyToolBarDropDown exportMenu = new EasyToolBarDropDown(Messages.RefinedResultViewer_Export, MemoryAnalyserPlugin.getImageDescriptor("icons/export.gif"), this.editor){

            public void contribute(PopupMenu menu) {
                menu.add(new ExportActions.HtmlExport((Control)RefinedResultViewer.this.control, RefinedResultViewer.this.result, RefinedResultViewer.this.context));
                menu.add(new ExportActions.CsvExport((Control)RefinedResultViewer.this.control, (IResult)RefinedResultViewer.this.result, RefinedResultViewer.this.context));
                menu.add(new ExportActions.TxtExport((Control)RefinedResultViewer.this.control));
            }
        };
        manager.add((IAction)calculateRetainedSizeMenu);
        manager.add((IAction)exportMenu);
        if (this.queryResult.getQuery() != null && this.queryResult.getQuery().getHelpUrl() != null) {
            manager.appendToGroup("help", (IAction)new OpenHelpPageAction(this.queryResult.getQuery().getHelpUrl()));
        }
    }

    public void addContextMenu(PopupMenu menu) {
        this.contextMenu.addContextActions(menu, this.getSelection(), this.getControl());
        this.addColumnsMenu(menu);
        this.addMoreMenu(menu);
    }

    private void addColumnsMenu(PopupMenu menu) {
        menu.addSeparator();
        PopupMenu columnsMenu = new PopupMenu(Messages.RefinedResultViewer_Columns);
        menu.add(columnsMenu);
        this.addFilterMenu(columnsMenu);
        this.addSortByMenu(columnsMenu);
    }

    private void addFilterMenu(PopupMenu menu) {
        PopupMenu filterMenu = new PopupMenu(Messages.RefinedResultViewer_EditFilter);
        menu.add(filterMenu);
        int ii = 0;
        while (ii < this.columns.length) {
            final int columnIndex = ii;
            Action action = new Action(this.columns[ii].getText()){

                public void run() {
                    Item item = RefinedResultViewer.this.adapter.getItem(null, 0);
                    Filter filter = RefinedResultViewer.this.result.getFilter()[columnIndex];
                    RefinedResultViewer.this.activateEditor(item, filter, columnIndex);
                }
            };
            filterMenu.add(action);
            ++ii;
        }
    }

    private void addConfigureColumnsMenu(PopupMenu menu) {
        Action columnsAction = new Action(Messages.RefinedResultViewer_ConfigureColumns){

            public void run() {
                RefinedResultViewer.this.configureColumns();
            }
        };
        menu.add(columnsAction);
    }

    private void addSortByMenu(PopupMenu menu) {
        PopupMenu sortByMenu = new PopupMenu(Messages.RefinedResultViewer_Sort_By);
        menu.add(sortByMenu);
        int ii = 0;
        while (ii < this.columns.length) {
            final int columnIndex = ii;
            Action action = new Action(this.columns[ii].getText()){

                public void run() {
                    RefinedResultViewer.this.resort(RefinedResultViewer.this.columns[columnIndex]);
                }
            };
            sortByMenu.add(action);
            ++ii;
        }
    }

    private void addMoreMenu(PopupMenu menu) {
        Item[] selection = this.adapter.getSelection();
        if (selection.length != 1) {
            return;
        }
        if (selection[0].getData() != null) {
            return;
        }
        ControlItem ctrl = null;
        final Item parent = this.adapter.getParentItem(selection[0]);
        if (parent == null) {
            if (this.adapter.indexOf(selection[0]) != 0) {
                ctrl = (ControlItem)this.control.getData("$control");
            }
        } else {
            ctrl = (ControlItem)parent.getData("$control");
        }
        if (ctrl != null && ctrl.totals != null && ctrl.totals.getVisibleItems() < ctrl.totals.getNumberOfItems()) {
            Action action;
            boolean isRest;
            menu.addSeparator();
            boolean bl = isRest = ctrl.totals.getNumberOfItems() - ctrl.totals.getVisibleItems() <= 25;
            if (!isRest) {
                action = new Action(Messages.RefinedResultViewer_Next25){

                    public void run() {
                        RefinedResultViewer.this.doRevealChildren(parent, 25);
                    }
                };
                action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/plus.gif"));
                menu.add(action);
            }
            action = new Action(Messages.RefinedResultViewer_CustomExpand){

                public void run() {
                    IInputValidator inputValidator = new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText == null || newText.length() == 0) {
                                return " ";
                            }
                            try {
                                if (Integer.parseInt(newText) > 0) {
                                    return null;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                            return Messages.RefinedResultViewer_notValidNumber;
                        }
                    };
                    InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.RefinedResultViewer_ExpandToLimit, Messages.RefinedResultViewer_EnterNumber, null, inputValidator);
                    if (inputDialog.open() == 1) {
                        return;
                    }
                    int number = new Integer(inputDialog.getValue());
                    RefinedResultViewer.this.doRevealChildren(parent, number);
                }
            };
            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/plus.gif"));
            menu.add(action);
            action = new Action(Messages.RefinedResultViewer_ExpandAll){

                public void run() {
                    RefinedResultViewer.this.doRevealChildren(parent, Integer.MAX_VALUE);
                }
            };
            action.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/plus.gif"));
            menu.add(action);
        }
    }

    private final void doRevealChildren(Item parent, int number) {
        int visible;
        if (parent != null && parent.isDisposed()) {
            return;
        }
        ControlItem ctrl = (ControlItem)(parent == null ? this.control.getData("$control") : parent.getData("$control"));
        if (ctrl == null || ctrl.totals == null) {
            return;
        }
        int n = visible = number == Integer.MAX_VALUE ? ctrl.totals.getNumberOfItems() : Math.min(ctrl.totals.getVisibleItems() + number, ctrl.totals.getNumberOfItems());
        if (visible - ctrl.totals.getVisibleItems() > 5000) {
            MessageBox box = new MessageBox(this.control.getShell(), 292);
            box.setMessage(MessageUtil.format((String)Messages.RefinedResultViewer_BlockingWarning, (Object[])new Object[]{visible - ctrl.totals.getVisibleItems()}));
            if (box.open() != 32) {
                return;
            }
        }
        ctrl.totals.setVisibleItems(visible);
        this.control.getParent().setRedraw(false);
        try {
            this.widgetRevealChildren(parent, ctrl.totals);
        }
        finally {
            this.control.getParent().setRedraw(true);
        }
    }

    protected abstract void widgetRevealChildren(Item var1, TotalsRow var2);

    private void activateEditor(final Item item, final Filter filter, final int columnIndex) {
        boolean showBorder = false;
        final Composite composite = new Composite(this.control, 0);
        final Text text = new Text(composite, 0);
        text.setText(" ");
        final int inset = showBorder ? 1 : 0;
        final DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                composite.dispose();
            }
        };
        item.addDisposeListener(disposeListener);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + inset, rect.y + inset, rect.width - inset * 2, rect.height - inset * 2);
            }
        });
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 16: {
                        this.updateCriteria(filter, columnIndex, text.getText());
                        if (item.isDisposed()) break;
                        item.removeDisposeListener(disposeListener);
                        composite.dispose();
                        break;
                    }
                    case 25: {
                        Rectangle cell = RefinedResultViewer.this.adapter.getBounds(item, columnIndex);
                        Rectangle image = RefinedResultViewer.this.adapter.getImageBounds(item, columnIndex);
                        RefinedResultViewer.this.controlEditor.minimumHeight = cell.height;
                        RefinedResultViewer.this.controlEditor.minimumWidth = cell.width - image.width;
                        RefinedResultViewer.this.controlEditor.layout();
                        break;
                    }
                    case 31: {
                        int newIndex = -1;
                        switch (e.detail) {
                            case 64: {
                                if ((e.stateMask & SWT.MOD2) == SWT.MOD2 && e.keyCode == 0x1000002) {
                                    int[] order = RefinedResultViewer.this.adapter.getColumnOrder();
                                    int i = 0;
                                    while (i < order.length - 1) {
                                        if (order[i] == columnIndex) {
                                            order[i] = order[i + 1];
                                            order[i + 1] = columnIndex;
                                            RefinedResultViewer.this.adapter.setColumnOrder(order);
                                            break;
                                        }
                                        ++i;
                                    }
                                    e.doit = true;
                                    e.detail = 0;
                                    break;
                                }
                                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 0x1000002) {
                                    this.updateCriteria(filter, columnIndex, text.getText());
                                    if (!item.isDisposed()) {
                                        item.removeDisposeListener(disposeListener);
                                        composite.dispose();
                                    }
                                    newIndex = columnIndex;
                                    int width = RefinedResultViewer.this.adapter.getColumnWidth(columnIndex);
                                    RefinedResultViewer.this.adapter.setColumnWidth(columnIndex, width + 1);
                                    e.doit = false;
                                    break;
                                }
                                if (e.keyCode != 0x1000002) break;
                                this.updateCriteria(filter, columnIndex, text.getText());
                                RefinedResultViewer.this.resort(RefinedResultViewer.this.columns[columnIndex], 1024);
                                e.doit = true;
                                e.detail = 0;
                                break;
                            }
                            case 16: {
                                if ((e.stateMask & SWT.MOD1) != 0) break;
                                this.updateCriteria(filter, columnIndex, text.getText());
                                if (!item.isDisposed()) {
                                    item.removeDisposeListener(disposeListener);
                                    composite.dispose();
                                }
                                int[] order = RefinedResultViewer.this.adapter.getColumnOrder();
                                newIndex = order[0];
                                int i = 1;
                                while (i < order.length) {
                                    if (order[i - 1] == columnIndex) {
                                        newIndex = order[i];
                                        break;
                                    }
                                    ++i;
                                }
                                e.doit = false;
                                break;
                            }
                            case 32: {
                                if ((e.stateMask & SWT.MOD2) == SWT.MOD2 && e.keyCode == 0x1000001) {
                                    int[] order = RefinedResultViewer.this.adapter.getColumnOrder();
                                    int i = 1;
                                    while (i < order.length) {
                                        if (order[i] == columnIndex) {
                                            order[i] = order[i - 1];
                                            order[i - 1] = columnIndex;
                                            RefinedResultViewer.this.adapter.setColumnOrder(order);
                                            break;
                                        }
                                        ++i;
                                    }
                                    e.doit = true;
                                    e.detail = 0;
                                    break;
                                }
                                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 0x1000001) {
                                    this.updateCriteria(filter, columnIndex, text.getText());
                                    if (!item.isDisposed()) {
                                        item.removeDisposeListener(disposeListener);
                                        composite.dispose();
                                    }
                                    newIndex = columnIndex;
                                    int width = RefinedResultViewer.this.adapter.getColumnWidth(columnIndex);
                                    RefinedResultViewer.this.adapter.setColumnWidth(columnIndex, width - 1);
                                    e.doit = false;
                                    break;
                                }
                                if (e.keyCode != 0x1000001) break;
                                this.updateCriteria(filter, columnIndex, text.getText());
                                RefinedResultViewer.this.resort(RefinedResultViewer.this.columns[columnIndex], 128);
                                e.doit = true;
                                e.detail = 0;
                                break;
                            }
                            case 8: {
                                if ((e.stateMask & SWT.MOD1) != 0) break;
                                if (!item.isDisposed()) {
                                    item.removeDisposeListener(disposeListener);
                                    composite.dispose();
                                }
                                int[] order = RefinedResultViewer.this.adapter.getColumnOrder();
                                newIndex = order[order.length - 1];
                                int i = 1;
                                while (i < order.length) {
                                    if (order[i] == columnIndex) {
                                        newIndex = order[i - 1];
                                        break;
                                    }
                                    ++i;
                                }
                                e.doit = false;
                                break;
                            }
                            case 4: {
                                this.updateCriteria(filter, columnIndex, text.getText());
                            }
                            case 2: {
                                if (!item.isDisposed()) {
                                    item.removeDisposeListener(disposeListener);
                                    composite.dispose();
                                }
                                e.doit = false;
                            }
                        }
                        if (newIndex < 0) break;
                        Filter[] f = RefinedResultViewer.this.result.getFilter();
                        RefinedResultViewer.this.activateEditor(RefinedResultViewer.this.adapter.getItem(null, 0), f[newIndex], newIndex);
                    }
                }
            }

            private void updateCriteria(Filter filter2, int columnIndex2, String text2) {
                boolean changed = false;
                try {
                    changed = filter2.setCriteria(text2);
                }
                catch (IllegalArgumentException e) {
                    ErrorHelper.showErrorMessage(e);
                }
                if (changed) {
                    RefinedResultViewer.this.applyFilterData(item, columnIndex2, filter2);
                    RefinedResultViewer.this.refresh(false);
                }
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        text.addListener(25, textListener);
        this.adapter.setEditor(composite, item, columnIndex);
        text.setText(filter.getCriteria() != null ? filter.getCriteria() : "");
        text.selectAll();
        text.setFocus();
    }

    public void showDerivedDataColumn(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        this.prepareColumns(provider, operation);
    }

    protected void prepareColumns(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        ContextDerivedData.DerivedColumn derivedColumn = this.context.getContextDerivedData().lookup(operation);
        Column queryColumn = this.result.getColumnFor(provider, derivedColumn);
        if (queryColumn == null) {
            queryColumn = this.result.addDerivedDataColumn(provider, derivedColumn);
            Item column = this.adapter.createColumn(queryColumn, this.columns.length, new ColumnSelectionListener());
            Item[] copy = new Item[this.columns.length + 1];
            System.arraycopy(this.columns, 0, copy, 0, this.columns.length);
            copy[this.columns.length] = column;
            this.columns = copy;
            this.applyFilterData(this.adapter.getItem(null, 0));
        }
    }

    protected void doCalculateDerivedValuesForAll(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        this.prepareColumns(provider, operation);
        boolean jobFound = false;
        for (RefinedStructuredResult.DerivedDataJobDefinition job : this.jobs) {
            if (!job.getContextProvider().hasSameTarget(provider)) continue;
            jobFound = true;
            job.setOperation(operation);
            break;
        }
        if (!jobFound) {
            this.jobs.add(new RefinedStructuredResult.DerivedDataJobDefinition(provider, operation));
        }
        ControlItem ctrl = (ControlItem)this.control.getData("$control");
        new DerivedDataJob.OnFullList(this, provider, operation, ctrl.children, null, ctrl).schedule();
    }

    protected void doCalculateDerivedValuesForSelection(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        this.prepareColumns(provider, operation);
        Item[] items = this.adapter.getSelection();
        if (items.length == 0) {
            return;
        }
        ArrayList<Item> widgetItems = new ArrayList<Item>();
        ArrayList<Object> subjectItems = new ArrayList<Object>();
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item tItem = itemArray[n2];
            Object subject = tItem.getData();
            if (subject != null) {
                widgetItems.add(tItem);
                subjectItems.add(subject);
            }
            ++n2;
        }
        if (widgetItems.size() > 0) {
            new DerivedDataJob.OnSelection(this, provider, operation, subjectItems, widgetItems).schedule();
        }
    }

    public RefinedStructuredResult getResult() {
        return this.result;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public final Control getControl() {
        return this.control;
    }

    public final IStructuredSelection getSelection() {
        Item[] items = this.adapter.getSelection();
        if (items.length == 0) {
            return StructuredSelection.EMPTY;
        }
        ArrayList<Object> selection = new ArrayList<Object>(items.length);
        int ii = 0;
        while (ii < items.length) {
            items[ii].getText();
            Object row = items[ii].getData();
            if (row != null) {
                selection.add(row);
            } else {
                Item parent = this.adapter.getParentItem(items[ii]);
                ControlItem ctrl = null;
                int ix = this.adapter.indexOf(items[ii]);
                int nx = this.adapter.getItemCount(parent);
                if (parent == null) {
                    if (ix != 0) {
                        ctrl = (ControlItem)this.control.getData("$control");
                    }
                } else {
                    ctrl = (ControlItem)parent.getData("$control");
                }
                if (ctrl != null && ctrl.getTotals() != null && ix + 1 == nx) {
                    int jj = ctrl.getTotals().getVisibleItems();
                    while (jj < ctrl.children.size()) {
                        selection.add(ctrl.children.get(jj));
                        ++jj;
                    }
                }
            }
            ++ii;
        }
        return new StructuredSelection(selection);
    }

    public final void setFocus() {
        this.control.setFocus();
    }

    protected final void resort() {
        List<?> children = ((ControlItem)this.control.getData((String)"$control")).children;
        if (children != null) {
            new SortingJob(this, children).schedule();
        }
    }

    protected final void resort(Item column) {
        Column queryColumn = (Column)column.getData();
        boolean isSorted = column == this.adapter.getSortColumn();
        int direction = 128;
        direction = isSorted ? (this.adapter.getSortDirection() == 128 ? 1024 : 128) : (queryColumn.isNumeric() ? 1024 : 128);
        this.control.getParent().setRedraw(false);
        this.resort(column, direction);
    }

    private final void resort(Item column, int direction) {
        Column queryColumn = (Column)column.getData();
        try {
            this.adapter.setSortColumn(column);
            this.adapter.setSortDirection(direction);
            this.result.setSortOrder(queryColumn, Column.SortDirection.of((int)direction));
            this.resort();
        }
        finally {
            this.control.getParent().setRedraw(true);
        }
    }

    protected abstract void refresh(boolean var1);

    protected abstract void doUpdateChildren(Item var1, ControlItem var2);

    public void dispose() {
        this.control.dispose();
        this.resourceManager.dispose();
    }

    private final class ColumnSelectionListener
    implements SelectionListener {
        private ColumnSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Item treeColumn = (Item)e.widget;
            RefinedResultViewer.this.resort(treeColumn);
        }
    }

    static class ControlItem {
        boolean expandAndSelect;
        int level;
        List<?> children;
        TotalsRow totals;
        boolean hasBeenPainted;

        public ControlItem(boolean expandAndSelect, int level) {
            this.expandAndSelect = expandAndSelect;
            this.level = level;
        }

        public String toString() {
            return String.valueOf(this.level) + " " + this.hashCode() + " " + this.totals;
        }

        public TotalsRow getTotals() {
            return this.totals;
        }
    }

    static interface Key {
        public static final String CONTROL = "$control";
    }

    protected static class RetrieveChildrenJob
    extends AbstractPaneJob
    implements ISchedulingRule {
        private RefinedResultViewer viewer;
        private ControlItem ctrl;
        private Item parentItem;
        private Object parent;

        protected RetrieveChildrenJob(RefinedResultViewer viewer, ControlItem ctrl, Item parentItem, Object parent) {
            super(Messages.RefinedResultViewer_RetrieveViewElements, viewer.pane);
            this.viewer = viewer;
            this.ctrl = ctrl;
            this.parentItem = parentItem;
            this.parent = parent;
            this.setUser(true);
            this.setRule(this);
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                this.loadElements();
                this.updateDisplay();
                this.calculateTotals(monitor);
                for (RefinedStructuredResult.DerivedDataJobDefinition job : this.viewer.jobs) {
                    new DerivedDataJob.OnFullList(this.viewer, job.getContextProvider(), job.getOperation(), this.ctrl.children, this.parentItem, this.ctrl).schedule();
                }
                return Status.OK_STATUS;
            }
            catch (RuntimeException e) {
                if (!this.viewer.control.isDisposed()) {
                    this.viewer.control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.isDisposed()) {
                                return;
                            }
                            ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(false);
                            try {
                                if (RetrieveChildrenJob.this.parentItem != null) {
                                    RetrieveChildrenJob.this.parentItem.setData("$control", null);
                                    ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.setItemCount(RetrieveChildrenJob.this.parentItem, 1);
                                    ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.setExpanded(RetrieveChildrenJob.this.parentItem, false);
                                } else {
                                    RetrieveChildrenJob.this.viewer.refresh(false);
                                }
                            }
                            finally {
                                ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(true);
                            }
                        }
                    });
                }
                if (e instanceof IProgressListener.OperationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                return ErrorHelper.createErrorStatus(e);
            }
        }

        private void calculateTotals(IProgressMonitor monitor) {
            boolean hasChildren;
            if (monitor.isCanceled()) {
                return;
            }
            boolean bl = hasChildren = this.ctrl.totals.getNumberOfItems() > 0 || this.ctrl.totals.getFilteredItems() > 0;
            if (hasChildren && this.ctrl.children.size() > 1) {
                this.viewer.result.calculateTotals(this.ctrl.children, this.ctrl.totals, (IProgressListener)new ProgressMonitorWrapper(monitor));
                if (!this.viewer.control.isDisposed()) {
                    this.viewer.control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.isDisposed()) {
                                return;
                            }
                            ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(false);
                            try {
                                if (RetrieveChildrenJob.this.parentItem == null) {
                                    int index = ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.getItemCount(null) - 1;
                                    Item item = ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.getItem(null, index);
                                    this.updateItem(item, (ControlItem)((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getData("$control"));
                                } else {
                                    if (RetrieveChildrenJob.this.parentItem.isDisposed()) {
                                        return;
                                    }
                                    int index = ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.getItemCount(RetrieveChildrenJob.this.parentItem) - 1;
                                    Item item = ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.adapter.getItem(RetrieveChildrenJob.this.parentItem, index);
                                    this.updateItem(item, (ControlItem)RetrieveChildrenJob.this.parentItem.getData("$control"));
                                }
                            }
                            finally {
                                ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(true);
                            }
                        }

                        private void updateItem(Item item, ControlItem ctrl) {
                            if (item.isDisposed()) {
                                return;
                            }
                            RetrieveChildrenJob.this.viewer.applyTotals(item, ctrl.totals);
                        }
                    });
                }
            }
        }

        private void updateDisplay() {
            if (!this.viewer.control.isDisposed()) {
                this.viewer.control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.isDisposed()) {
                            return;
                        }
                        ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(false);
                        try {
                            RetrieveChildrenJob.this.viewer.doUpdateChildren(RetrieveChildrenJob.this.parentItem, RetrieveChildrenJob.this.ctrl);
                        }
                        finally {
                            ((RetrieveChildrenJob)RetrieveChildrenJob.this).viewer.control.getParent().setRedraw(true);
                        }
                    }
                });
            }
        }

        private void loadElements() {
            if (this.ctrl == null) {
                this.ctrl = new ControlItem(false, 0);
            }
            this.ctrl.children = this.viewer.getElements(this.parent);
            this.ctrl.totals = this.viewer.result.buildTotalsRow(this.ctrl.children);
            if (this.parent != null) {
                this.ctrl.totals.setVisibleItems(Math.min(25, this.ctrl.totals.getNumberOfItems()));
            } else if (this.viewer.rootTotalsRow != null && this.viewer.rootTotalsRow.getVisibleItems() > this.ctrl.totals.getVisibleItems()) {
                this.ctrl.totals.setVisibleItems(Math.min(this.ctrl.totals.getNumberOfItems(), Math.max(this.viewer.rootTotalsRow.getVisibleItems(), this.viewer.visibleItemsEstimate)));
            } else {
                this.ctrl.totals.setVisibleItems(Math.min(this.viewer.visibleItemsEstimate, this.ctrl.totals.getNumberOfItems()));
            }
            if (this.parent == null) {
                this.viewer.rootTotalsRow = this.ctrl.totals;
            }
        }

        public boolean contains(ISchedulingRule rule) {
            return rule.getClass() == ((Object)((Object)this)).getClass();
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingJob
    extends AbstractPaneJob {
        RefinedResultViewer viewer;
        List<?> list;

        private SortingJob(RefinedResultViewer viewer, List<?> list) {
            super(Messages.RefinedResultViewer_Sorting, viewer.pane);
            this.viewer = viewer;
            this.list = list;
            this.setUser(true);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            this.viewer.result.sort(this.list);
            if (!this.viewer.control.isDisposed()) {
                this.viewer.control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SortingJob.this.viewer.control.isDisposed()) {
                            return;
                        }
                        try {
                            SortingJob.this.viewer.control.getParent().setRedraw(false);
                            SortingJob.this.viewer.doUpdateChildren(null, (ControlItem)SortingJob.this.viewer.control.getData("$control"));
                        }
                        finally {
                            SortingJob.this.viewer.control.getParent().setRedraw(true);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    static interface WidgetAdapter {
        public Composite createControl(Composite var1);

        public Item createColumn(Column var1, int var2, SelectionListener var3);

        public ControlEditor createEditor();

        public void setEditor(Composite var1, Item var2, int var3);

        public Item[] getSelection();

        public int indexOf(Item var1);

        public Item getItem(Item var1, int var2);

        public Item getParentItem(Item var1);

        public Item getItem(Point var1);

        public Rectangle getBounds(Item var1, int var2);

        public Rectangle getImageBounds(Item var1, int var2);

        public void apply(Item var1, int var2, String var3, Color var4, Font var5);

        public void apply(Item var1, int var2, String var3);

        public void apply(Item var1, Font var2);

        public Font getFont();

        public Item getSortColumn();

        public int getSortDirection();

        public void setSortColumn(Item var1);

        public void setSortDirection(int var1);

        public void setItemCount(Item var1, int var2);

        public int getItemCount(Item var1);

        public void setExpanded(Item var1, boolean var2);

        public Rectangle getTextBounds(Widget var1, int var2);

        public int getLineHeightEstimation();

        public int[] getColumnOrder();

        public void setColumnOrder(int[] var1);

        public int getColumnWidth(int var1);

        public void setColumnWidth(int var1, int var2);
    }
}

