/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorPage;
import org.eclipse.mylyn.internal.builds.ui.editor.TimestampToStringConverter;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildEditorPart
extends AbstractFormPart {
    private Control control;
    private BuildEditorPage page;
    private String partId;
    private String partName;
    private Section section;
    private final int sectionStyle;
    int span = 1;
    boolean expandVertically;

    public AbstractBuildEditorPart() {
        this(258);
    }

    public AbstractBuildEditorPart(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }

    public Control createControl(Composite parent, final FormToolkit toolkit) {
        this.section = this.createSection(parent, toolkit);
        if ((this.section.getExpansionStyle() & 0x40) != 0) {
            Control content = this.createContent((Composite)this.section, toolkit);
            this.section.setClient(content);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (AbstractBuildEditorPart.this.section.getClient() == null) {
                        Control content = AbstractBuildEditorPart.this.createContent((Composite)AbstractBuildEditorPart.this.section, toolkit);
                        AbstractBuildEditorPart.this.section.setClient(content);
                        AbstractBuildEditorPart.this.getPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    public BuildEditorPage getPage() {
        return this.page;
    }

    public String getPartId() {
        return this.partId;
    }

    public String getPartName() {
        return this.partName;
    }

    public Section getSection() {
        return this.section;
    }

    public int getSpan() {
        return this.span;
    }

    public void initialize(BuildEditorPage page) {
        this.page = page;
    }

    private void createInfoOverlay(Composite composite, Section section, FormToolkit toolkit) {
        String text = this.getInfoOverlayText();
        if (text == null) {
            return;
        }
        final Label label = toolkit.createLabel(composite, CommonUiUtil.toLabel((String)text));
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setBackground(null);
        label.setVisible(!section.isExpanded());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                label.setVisible(!e.getState());
            }
        });
    }

    private IBuild getBuild() {
        return this.getPage().getEditorInput().getBuild();
    }

    private IBuildPlan getPlan() {
        return this.getPage().getEditorInput().getPlan();
    }

    protected Binding bind(Text text, Class<? extends IBuildElement> clazz, EStructuralFeature feature) {
        return this.bind(text, clazz, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{feature}));
    }

    protected Binding bind(Text text, Class<? extends IBuildElement> clazz, FeaturePath path) {
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        IEMFValueProperty property = EMFProperties.value((FeaturePath)path);
        ISWTObservableValue uiObservable = textProp.observe((Widget)text);
        IObservableValue modelObservable = property.observe((Object)this.getInput(clazz));
        UpdateValueStrategy modelToTargetStrategy = null;
        EStructuralFeature feature = path.getFeaturePath()[path.getFeaturePath().length - 1];
        String name = feature.getEType().getName();
        if (name.equals("ELong")) {
            modelToTargetStrategy = new UpdateValueStrategy();
            modelToTargetStrategy.setConverter((IConverter)new TimestampToStringConverter());
        } else {
            modelToTargetStrategy = new EMFUpdateValueStrategy();
        }
        return this.getPage().getDataBindingContext().bindValue((IObservableValue)uiObservable, modelObservable, null, modelToTargetStrategy);
    }

    protected abstract Control createContent(Composite var1, FormToolkit var2);

    protected Label createLabel(Composite parent, FormToolkit toolkit, String value) {
        Label label = toolkit.createLabel(parent, value);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    protected Section createSection(Composite parent, FormToolkit toolkit) {
        return this.createSection(parent, toolkit, this.sectionStyle);
    }

    protected Section createSection(Composite parent, FormToolkit toolkit, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(this.getPartName());
        return section;
    }

    protected Text createTextReadOnly(Composite parent, FormToolkit toolkit, String value) {
        return this.createTextReadOnly(parent, toolkit, value, 0);
    }

    protected Text createTextReadOnly(Composite parent, FormToolkit toolkit, String value, int style) {
        Text text = new Text(parent, 0x800008 | style);
        text.setFont(EditorUtil.TEXT_FONT);
        text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        text.setText(value);
        toolkit.adapt((Control)text, false, false);
        return text;
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
    }

    protected String getInfoOverlayText() {
        return null;
    }

    protected <T extends IBuildElement> T getInput(Class<T> clazz) {
        if (clazz == IBuildPlan.class) {
            return (T)this.getPlan();
        }
        if (clazz == IBuild.class) {
            return (T)this.getBuild();
        }
        return null;
    }

    protected IMessageManager getMessageManager() {
        if (this.getPage().getEditor() instanceof SharedHeaderFormEditor) {
            return ((SharedHeaderFormEditor)this.getPage().getEditor()).getHeaderForm().getForm().getMessageManager();
        }
        return this.getManagedForm().getMessageManager();
    }

    protected void inputChanged(IBuildElement oldInput, IBuildElement newInput) {
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                Composite toolbarComposite = toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.center = true;
                toolbarComposite.setLayout((Layout)rowLayout);
                this.createInfoOverlay(toolbarComposite, section, toolkit);
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
                if (section.getClient() instanceof Composite && ((Composite)section.getClient()).getLayout() instanceof GridLayout) {
                    GridLayout layout = (GridLayout)((Composite)section.getClient()).getLayout();
                    layout.marginHeight = 0;
                    layout.marginTop = 1;
                    layout.marginBottom = 5;
                }
                section.setTextClient((Control)toolbarComposite);
            } else {
                section.clientVerticalSpacing = PlatformUiUtil.getToolbarSectionClientVerticalSpacing();
            }
        }
        this.setControl((Control)section);
    }

    void setControl(Control control) {
        this.control = control;
    }

    void setPartId(String partId) {
        this.partId = partId;
    }

    public boolean getExpandVertically() {
        return this.expandVertically;
    }

    public void setExpandVertically(boolean expandVertically) {
        this.expandVertically = expandVertically;
    }
}

