/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtils {
    public static final String DELIMITER = "::";

    public static void setAttribute(String key, Collection<String> values, IRepositoryQuery query) {
        if (key == null || query == null) {
            return;
        }
        if (values != null && !values.isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (String entry : values) {
                value.append(entry).append(DELIMITER);
            }
            query.setAttribute(key, value.toString());
        } else {
            query.setAttribute(key, null);
        }
    }

    public static List<String> getAttributes(String key, IRepositoryQuery query) {
        String[] values;
        if (key == null || query == null) {
            return Collections.emptyList();
        }
        String attribute = query.getAttribute(key);
        if (attribute == null || attribute.length() == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> attrs = new LinkedList<String>();
        String[] stringArray = values = attribute.split(DELIMITER);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.length() > 0) {
                attrs.add(value);
            }
            ++n2;
        }
        return attrs;
    }
}

