/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.oslc.core.IOslcConnector;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.ui.Messages;
import org.eclipse.mylyn.internal.oslc.ui.OslcServiceDiscoveryWizard;
import org.eclipse.mylyn.internal.oslc.ui.OslcServiceDiscoveryWizardDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class OslcRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private OslcServiceDescriptor descriptor;
    protected Text baseText;

    public OslcRepositorySettingsPage(String name, String desc, TaskRepository taskRepository) {
        super(name, desc, taskRepository);
        this.setNeedsAnonymousLogin(false);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(false);
    }

    public OslcServiceDescriptor getProvider() {
        return this.descriptor;
    }

    public void setServiceDescriptor(OslcServiceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected String getBaseUrl() {
        return this.baseText.getText();
    }

    protected void createSettingControls(Composite parent) {
        String base;
        Label baseUrlLabel = new Label(parent, 0);
        baseUrlLabel.setText("Base URL:");
        this.baseText = new Text(parent, 2048);
        if (this.repository != null && (base = this.repository.getProperty("oslc.baseurl")) != null) {
            this.baseText.setText(base);
        }
        this.baseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OslcRepositorySettingsPage.this.serverUrlCombo.setText(OslcRepositorySettingsPage.this.baseText.getText());
                if (OslcRepositorySettingsPage.this.getWizard() != null) {
                    OslcRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        GridDataFactory.fillDefaults().hint(300, -1).span(2, 1).grab(true, false).applyTo((Control)this.baseText);
        super.createSettingControls(parent);
        if (this.serverUrlCombo.getText().length() == 0) {
            this.serverUrlCombo.setText(Messages.OslcRepositorySettingsPage_Enter_Base_Url_Above);
        }
        this.serverUrlCombo.setEnabled(false);
    }

    public abstract String getConnectorKind();

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new OslcValidator(this.createTaskRepository(), this.baseText.getText());
    }

    public void applyTo(TaskRepository repository) {
        repository.setProperty("oslc.baseurl", this.baseText.getText());
        super.applyTo(repository);
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        OslcValidator cqValidator = (OslcValidator)validator;
        if (!cqValidator.getProviders().isEmpty()) {
            if (this.repository == null) {
                this.repository = this.createTaskRepository();
            }
            OslcServiceDiscoveryWizard oslcWizard = new OslcServiceDiscoveryWizard((IOslcConnector)this.connector, cqValidator.getRepository(), cqValidator.getProviders());
            OslcServiceDiscoveryWizardDialog dialog = new OslcServiceDiscoveryWizardDialog(this.getShell(), (IWizard)oslcWizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0 && oslcWizard.getSelectedServiceDescriptor() != null) {
                this.setUrl(oslcWizard.getSelectedServiceDescriptor().getAboutUrl());
                this.setServiceDescriptor(oslcWizard.getSelectedServiceDescriptor());
            } else {
                cqValidator.setStatus(Status.CANCEL_STATUS);
            }
        }
        super.applyValidatorResult(validator);
    }

    protected void createAdditionalControls(Composite parent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OslcValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;
        private List<OslcServiceProvider> providers;
        private final String baseUrl;

        public TaskRepository getRepository() {
            return this.repository;
        }

        public OslcValidator(TaskRepository repository, String baseUrl) {
            super((AbstractRepositorySettingsPage)OslcRepositorySettingsPage.this);
            this.providers = new ArrayList<OslcServiceProvider>();
            this.repository = repository;
            this.baseUrl = baseUrl;
        }

        private String getBaseUrl() {
            return this.baseUrl;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                new URL(this.getBaseUrl());
                List serviceProviders = ((IOslcConnector)OslcRepositorySettingsPage.this.connector).getAvailableServices(this.repository, this.getBaseUrl(), monitor);
                this.setProviders(serviceProviders);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", 0, INVALID_REPOSITORY_URL, null));
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Error occurred during service discovery", (Throwable)e));
                throw e;
            }
        }

        private void setProviders(List<OslcServiceProvider> providers) {
            this.providers = providers;
        }

        public List<OslcServiceProvider> getProviders() {
            return this.providers;
        }
    }
}

