/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.ui;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.oslc.core.IOslcConnector;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProviderCatalog;
import org.eclipse.mylyn.internal.oslc.ui.Messages;
import org.eclipse.mylyn.internal.oslc.ui.OslcServiceDiscoveryProvider;
import org.eclipse.mylyn.internal.oslc.ui.OslcServiceLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcServiceDiscoveryWizardPage
extends WizardPage {
    private static final String TITLE_SERVICE_DISCOVERY = Messages.OslcServiceDiscoveryWizardPage_Serivce_Discovery;
    private TreeViewer v;
    private OslcServiceDescriptor selectedServiceDescriptor;
    private final TaskRepository repository;
    private final OslcServiceDiscoveryProvider provider;
    private List<OslcServiceProvider> rootProviders;

    protected OslcServiceDiscoveryWizardPage(IOslcConnector connector, TaskRepository repository) {
        super(TITLE_SERVICE_DISCOVERY, TITLE_SERVICE_DISCOVERY, TasksUiImages.BANNER_REPOSITORY);
        this.repository = repository;
        this.provider = new OslcServiceDiscoveryProvider(connector, repository, null);
        this.setMessage(Messages.OslcServiceDiscoveryWizardPage_Browse_Available_Services_Below);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.v = new TreeViewer(composite, 0x10000800);
        this.v.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.v.getTree());
        this.v.setLabelProvider((IBaseLabelProvider)new OslcServiceLabelProvider());
        this.v.setContentProvider((IContentProvider)this.provider);
        this.v.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)OslcServiceDiscoveryWizardPage.this.v.getSelection();
                Object o = selection.getFirstElement();
                if (o instanceof OslcServiceDiscoveryProvider.ServiceProviderCatalogWrapper) {
                    Object provObj = ((OslcServiceDiscoveryProvider.ServiceProviderCatalogWrapper)o).getServiceObject();
                    if (provObj instanceof OslcServiceProviderCatalog) {
                        OslcServiceDiscoveryWizardPage.this.setSelectedServiceDescriptor(null);
                    } else if (provObj instanceof OslcServiceProvider) {
                        OslcServiceDiscoveryWizardPage.this.setSelectedServiceDescriptor(null);
                    } else if (provObj instanceof OslcServiceDescriptor) {
                        OslcServiceDiscoveryWizardPage.this.setSelectedServiceDescriptor((OslcServiceDescriptor)provObj);
                    }
                }
            }
        });
        if (this.rootProviders != null && !this.rootProviders.isEmpty()) {
            this.v.setInput(this.rootProviders);
        } else {
            this.v.setInput((Object)new OslcServiceProviderCatalog(this.repository.getRepositoryLabel(), this.repository.getUrl()));
        }
        this.setControl((Control)composite);
    }

    private void setSelectedServiceDescriptor(OslcServiceDescriptor selectedServiceDescriptor) {
        this.selectedServiceDescriptor = selectedServiceDescriptor;
        this.setPageComplete(selectedServiceDescriptor != null);
    }

    public OslcServiceDescriptor getSelectedServiceProvider() {
        return this.selectedServiceDescriptor;
    }

    public void setRootProviders(List<OslcServiceProvider> providers) {
        this.rootProviders = providers;
    }
}

