/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.reviews.ui.compare.ByteArrayInput;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.swt.graphics.Image;

public class FileItemNode
extends DiffNode {
    private final IFileItem fileItem;
    private IPath path;
    private String name;
    private static CommonImageManger imageManger;

    public FileItemNode(IFileItem fileItem) {
        super(0);
        String basePath;
        this.fileItem = fileItem;
        byte[] targetContent = CompareUtil.getContent(fileItem.getTarget());
        byte[] baseContent = CompareUtil.getContent(fileItem.getBase());
        String targetPath = fileItem.getTarget().getPath();
        int kind = 3;
        if (targetPath == null) {
            targetPath = fileItem.getBase().getPath();
            kind = 1;
        }
        if ((basePath = fileItem.getBase().getPath()) == null) {
            basePath = targetPath;
            kind = 2;
        }
        if (targetPath.equals("/COMMIT_MSG")) {
            kind = 0;
        }
        this.setLeft(new ByteArrayInput(targetContent, targetPath));
        this.setRight(new ByteArrayInput(baseContent, basePath));
        this.setKind(kind);
        IPath path = Path.fromPortableString((String)targetPath);
        this.setPath(path);
        this.name = path.lastSegment();
    }

    public FileItemNode(String name) {
        super(0);
        this.name = name;
        this.fileItem = null;
    }

    public IFileItem getFileItem() {
        return this.fileItem;
    }

    public Image getImage() {
        if (imageManger == null) {
            imageManger = new CommonImageManger();
        }
        return this.fileItem != null ? imageManger.getFileImage(this.getName()) : imageManger.getFolderImage();
    }

    public String getName() {
        return this.name;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getType() {
        return this.fileItem != null ? super.getType() : "FOLDER";
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }
}

