/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTasksJob
extends TaskJob {
    private final Collection<ITask> tasksToDelete;
    private MultiStatus status;
    private final IRepositoryManager repositoryManager;

    public DeleteTasksJob(String name, Collection<ITask> tasksToDelete, IRepositoryManager repositoryManager) {
        super(name);
        Assert.isNotNull(tasksToDelete);
        Assert.isNotNull((Object)repositoryManager);
        this.repositoryManager = repositoryManager;
        this.tasksToDelete = tasksToDelete;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.status = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, "Problems occurred while deleting repository tasks", null);
        for (ITask task : this.tasksToDelete) {
            String taskId;
            TaskRepository repository;
            AbstractRepositoryConnector repositoryConnector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind());
            if (!repositoryConnector.canDeleteTask(repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl()), task)) continue;
            try {
                repositoryConnector.deleteTask(repository, task, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                taskId = task.getTaskKey();
                if (taskId == null) {
                    taskId = task.getTaskId();
                }
                this.status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Problems occurred while deleting {0} from {1}.", (Object)taskId, (Object)task.getRepositoryUrl()), (Throwable)e));
            }
            catch (LinkageError e) {
                taskId = task.getTaskKey();
                if (taskId == null) {
                    taskId = task.getTaskId();
                }
                this.status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Internal Error occurred while deleting {0} from {1}.", (Object)taskId, (Object)task.getRepositoryUrl()), (Throwable)e));
            }
        }
        return Status.OK_STATUS;
    }
}

