/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentUtil {
    protected static final int BUFFER_SIZE = 1024;
    public static final String CONTEXT_DESCRIPTION = "mylyn/context/zip";
    private static final String CONTEXT_DESCRIPTION_LEGACY = "mylar/context/zip";
    private static final String CONTEXT_FILENAME = "mylyn-context.zip";
    private static final String CONTEXT_CONTENT_TYPE = "application/octet-stream";
    private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
    private static final String CTYPE_ZIP = "zip";
    private static final String CTYPE_TEXT = "text";
    private static final String CTYPE_HTML = "html";

    public static boolean postContext(AbstractRepositoryConnector connector, TaskRepository repository, ITask task, String comment, TaskAttribute attribute, IProgressMonitor monitor) throws CoreException {
        AbstractTaskAttachmentHandler attachmentHandler = connector.getTaskAttachmentHandler();
        TasksUiPlugin.getContextStore().saveActiveContext();
        File file = TasksUiPlugin.getContextStore().getFileForContext(task);
        if (attachmentHandler != null && file != null && file.exists()) {
            FileTaskAttachmentSource attachment = new FileTaskAttachmentSource(file);
            attachment.setDescription(CONTEXT_DESCRIPTION);
            attachment.setName(CONTEXT_FILENAME);
            attachmentHandler.postContent(repository, task, (AbstractTaskAttachmentSource)attachment, comment, attribute, monitor);
            return true;
        }
        return false;
    }

    public static List<ITaskAttachment> getContextAttachments(TaskRepository repository, ITask task) {
        TaskData taskData;
        ArrayList<ITaskAttachment> contextAttachments = new ArrayList<ITaskAttachment>();
        try {
            taskData = TasksUi.getTaskDataManager().getTaskData(task);
        }
        catch (CoreException coreException) {
            return contextAttachments;
        }
        if (taskData != null) {
            List taskAttachments = taskData.getAttributeMapper().getAttributesByType(taskData, ATTACHMENT_DEFAULT_NAME);
            for (TaskAttribute attribute : taskAttachments) {
                TaskAttachment taskAttachment = new TaskAttachment(repository, task, attribute);
                taskData.getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, attribute);
                if (!AttachmentUtil.isContext((ITaskAttachment)taskAttachment)) continue;
                contextAttachments.add((ITaskAttachment)taskAttachment);
            }
        }
        return contextAttachments;
    }

    public static boolean hasContextAttachment(ITask task) {
        Assert.isNotNull((Object)task);
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        List<ITaskAttachment> contextAttachments = AttachmentUtil.getContextAttachments(repository, task);
        return contextAttachments.size() > 0;
    }

    public static boolean downloadContext(final ITask task, final ITaskAttachment attachment, IRunnableContext context) {
        if (task.isActive()) {
            TasksUi.getTaskActivityManager().deactivateTask(task);
        }
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    File targetFile = TasksUiPlugin.getContextStore().getFileForContext(task);
                    try {
                        boolean exceptionThrown = true;
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                        try {
                            try {
                                AttachmentUtil.downloadAttachment(attachment, out, monitor);
                                exceptionThrown = false;
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            ((OutputStream)out).close();
                            if (exceptionThrown) {
                                targetFile.delete();
                            }
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 5, "Error writing to context file", (Throwable)e)));
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus(Messages.AttachmentUtil_Mylyn_Information, ((CoreException)e.getCause()).getStatus());
            } else {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while retrieving context", (Throwable)e), 3);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)task);
        TasksUiInternal.activateTaskThroughCommand(task);
        return true;
    }

    public static boolean uploadContext(TaskRepository repository, ITask task, String comment, IRunnableContext context) {
        TasksUiPlugin.getContextStore().saveActiveContext();
        File sourceContextFile = TasksUiPlugin.getContextStore().getFileForContext(task);
        if (!sourceContextFile.exists()) {
            TasksUiInternal.displayStatus(Messages.AttachmentUtil_Mylyn_Information, (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", Messages.AttachmentUtil_The_context_is_empty));
            return false;
        }
        FileTaskAttachmentSource source = new FileTaskAttachmentSource(sourceContextFile);
        source.setName(CONTEXT_FILENAME);
        source.setDescription(CONTEXT_DESCRIPTION);
        source.setContentType(CONTEXT_CONTENT_TYPE);
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        final SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskAttachmentJob(connector, repository, task, (AbstractTaskAttachmentSource)source, comment, null);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (((SubmitTaskAttachmentJob)submitJob).run(monitor) == Status.CANCEL_STATUS) {
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while attaching context", (Throwable)e), 3);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IStatus status = submitJob.getStatus();
        if (status != null && status.getSeverity() != 8) {
            TasksUiInternal.displayStatus(Messages.AttachmentUtil_Mylyn_Information, submitJob.getStatus());
            return false;
        }
        return true;
    }

    public static boolean hasLocalContext(ITask task) {
        Assert.isNotNull((Object)task);
        return TasksUiPlugin.getContextStore().hasContext(task);
    }

    public static boolean isContext(ITaskAttachment attachment) {
        return CONTEXT_DESCRIPTION.equals(attachment.getDescription()) || CONTEXT_DESCRIPTION_LEGACY.equals(attachment.getDescription());
    }

    public static boolean canUploadAttachment(ITask task) {
        AbstractRepositoryConnector connector;
        AbstractTaskAttachmentHandler attachmentHandler;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        if (repository != null && (attachmentHandler = (connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind())).getTaskAttachmentHandler()) != null) {
            return attachmentHandler.canPostContent(repository, task);
        }
        return false;
    }

    public static boolean canDownloadAttachment(ITask task) {
        AbstractRepositoryConnector connector;
        AbstractTaskAttachmentHandler attachmentHandler;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        if (repository != null && (attachmentHandler = (connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind())).getTaskAttachmentHandler()) != null) {
            return attachmentHandler.canGetContent(repository, task);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadAttachment(ITaskAttachment attachment, OutputStream out, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(Messages.AttachmentUtil_Downloading_attachment, -1);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(attachment.getConnectorKind());
            AbstractTaskAttachmentHandler handler = connector.getTaskAttachmentHandler();
            if (handler == null) {
                throw new CoreException((IStatus)new RepositoryStatus(1, "org.eclipse.mylyn.tasks.ui", 7, "The repository does not support attachments."));
            }
            InputStream in = handler.getContent(attachment.getTaskRepository(), attachment.getTask(), attachment.getTaskAttribute(), monitor);
            try {
                byte[] buffer = new byte[1024];
                while (true) {
                    Policy.checkCanceled((IProgressMonitor)monitor);
                    int count = in.read(buffer);
                    if (count == -1) {
                        return;
                    }
                    out.write(buffer, 0, count);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new RepositoryStatus(attachment.getTaskRepository(), 4, "org.eclipse.mylyn.tasks.ui", 5, "IO error reading attachment: " + e.getMessage(), (Throwable)e));
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error closing attachment stream", (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public static ITaskAttachment getSelectedAttachment() {
        List<ITaskAttachment> attachments = AttachmentUtil.getSelectedAttachments(null);
        if (attachments.isEmpty()) {
            return null;
        }
        return attachments.get(0);
    }

    public static List<ITaskAttachment> getSelectedAttachments(ExecutionEvent event) {
        ISelection selection;
        if (event == null) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            if (service != null) {
                event = new ExecutionEvent(null, Collections.emptyMap(), null, (Object)service.getCurrentState());
            } else {
                return Collections.emptyList();
            }
        }
        if ((selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) == null || selection.isEmpty()) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List items = ((IStructuredSelection)selection).toList();
            ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
            for (Object item : items) {
                if (!(item instanceof ITaskAttachment)) continue;
                attachments.add((ITaskAttachment)item);
            }
            return attachments;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static List<ITaskAttachment> getSelectedAttachments() {
        ISelection windowSelection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (windowSelection = window.getSelectionService().getSelection()) instanceof IStructuredSelection && !windowSelection.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)windowSelection;
            List items = selection.toList();
            ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
            for (Object item : items) {
                if (!(item instanceof ITaskAttachment)) continue;
                attachments.add((ITaskAttachment)item);
            }
            return attachments;
        }
        return Collections.emptyList();
    }

    public static String getAttachmentFilename(ITaskAttachment attachment) {
        Assert.isNotNull((Object)attachment);
        String name = attachment.getFileName();
        if (name != null && name.length() > 0) {
            return CoreUtil.asFileName((String)name);
        }
        String extension = "";
        String ctype = attachment.getContentType();
        if (ctype != null) {
            if (ctype.endsWith(CTYPE_HTML)) {
                extension = ".html";
            } else if (ctype.startsWith(CTYPE_TEXT)) {
                extension = ".txt";
            } else if (ctype.endsWith(CTYPE_ZIP)) {
                extension = ".zip";
            } else {
                int i = ctype.lastIndexOf("/");
                if (i != -1) {
                    extension = "." + ctype.substring(i + 1);
                }
            }
        }
        return ATTACHMENT_DEFAULT_NAME + extension;
    }
}

