/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.DocumentProcessor;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Selector;

public class RepairBrokenCSSColorStylesProcessor
extends DocumentProcessor {
    public void process(Document document) {
        Element body = document.body();
        CssParser cssParser = new CssParser();
        for (Element element : Selector.select((String)"[style]", (Element)body)) {
            String style = element.attr("style");
            String newStyle = "";
            List<CssRule> rules = null;
            CssRule newRule = null;
            if (style != null && style.length() > 0) {
                rules = cssParser.parseBlockContent(style);
                Iterator<CssRule> ruleIt = rules.iterator();
                while (ruleIt.hasNext()) {
                    CssRule rule = ruleIt.next();
                    if (!"color".equals(rule.name)) continue;
                    String color = rule.value;
                    Matcher invalidHexColorMatcher = Pattern.compile("^\\s*([0-9a-fA-F]{6}|[0-9a-fA-F]{3})(?:\\s+(.+))?\\s*$").matcher(color);
                    if (!invalidHexColorMatcher.matches()) continue;
                    String newColor = "#" + invalidHexColorMatcher.group(1);
                    String additionalDeclarations = invalidHexColorMatcher.group(2);
                    if (additionalDeclarations != null) {
                        newColor = String.valueOf(newColor) + " " + additionalDeclarations;
                    }
                    ruleIt.remove();
                    newRule = new CssRule("color", newColor.trim(), 0, 0, 0, 0);
                }
            }
            if (rules == null || newRule == null) continue;
            newStyle = this.addRuleToStyle(newStyle, newRule);
            for (CssRule rule : rules) {
                newStyle = this.addRuleToStyle(newStyle, rule);
            }
            element.attr("style", newStyle);
        }
    }

    private String addRuleToStyle(String style, CssRule rule) {
        style = String.valueOf(style) + rule.name + ": " + rule.value + ";";
        return style;
    }
}

