/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarkupLanguage
extends MarkupLanguage {
    protected List<Block> blocks = new ArrayList<Block>();
    protected List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    protected MarkupLanguage.PatternBasedSyntax tokenSyntax = new MarkupLanguage.PatternBasedSyntax();
    protected MarkupLanguage.PatternBasedSyntax phraseModifierSyntax = new MarkupLanguage.PatternBasedSyntax();

    @Override
    protected MarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return this.phraseModifierSyntax;
    }

    @Override
    protected MarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return this.tokenSyntax;
    }

    @Override
    public final List<Block> getBlocks() {
        return this.blocks;
    }

    public final List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    @Override
    protected final void initializeSyntax() {
        if (!this.blocks.isEmpty()) {
            this.clearLanguageSyntax();
        }
        this.initializeBlocks();
        this.initializePhraseModifiers();
        this.initializeTokens();
    }

    protected void clearLanguageSyntax() {
        this.blocks.clear();
        this.paragraphBreakingBlocks.clear();
        this.tokenSyntax.clear();
        this.phraseModifierSyntax.clear();
    }

    protected final void initializeTokens() {
        this.addStandardTokens(this.tokenSyntax);
        this.addTokenExtensions(this.tokenSyntax);
        if (this.configuration != null) {
            this.configuration.addTokenExtensions(this.tokenSyntax);
        }
    }

    protected final void initializePhraseModifiers() {
        this.addStandardPhraseModifiers(this.phraseModifierSyntax);
        this.addPhraseModifierExtensions(this.phraseModifierSyntax);
        if (this.configuration != null) {
            this.configuration.addPhraseModifierExtensions(this.phraseModifierSyntax);
        }
    }

    protected final void initializeBlocks() {
        this.addStandardBlocks(this.blocks, this.paragraphBreakingBlocks);
        this.addBlockExtensions(this.blocks, this.paragraphBreakingBlocks);
        if (this.configuration != null) {
            this.configuration.addBlockExtensions(this.blocks, this.paragraphBreakingBlocks);
        }
        this.blocks.add(this.createParagraphBlock());
    }

    protected abstract void addStandardTokens(MarkupLanguage.PatternBasedSyntax var1);

    protected abstract void addStandardPhraseModifiers(MarkupLanguage.PatternBasedSyntax var1);

    protected abstract void addStandardBlocks(List<Block> var1, List<Block> var2);

    protected abstract Block createParagraphBlock();

    protected void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
    }

    protected void addTokenExtensions(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
    }

    protected void addPhraseModifierExtensions(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
    }
}

