/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import org.eclipse.internal.net4j.buffer.Buffer;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.ssl.SSLEngineManager;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class SSLBuffer
extends Buffer {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SSLBUFFER, SSLBuffer.class);
    private SSLEngineManager sslEngineManager;

    public SSLBuffer(IBufferProvider provider, short capacity, SSLEngineManager sslEngineManager) {
        super(provider, capacity);
        this.sslEngineManager = sslEngineManager;
    }

    public ByteBuffer startGetting(SocketChannel socketChannel) throws IOException {
        BufferState state = this.getState();
        if (state != BufferState.INITIAL && state != BufferState.READING_HEADER && state != BufferState.READING_BODY) {
            throw new IllegalStateException(this.toString());
        }
        int readSize = 0;
        readSize = this.sslEngineManager.getAppRecvBuf().position() > 0 ? this.sslEngineManager.getAppRecvBuf().position() : this.sslEngineManager.read(socketChannel);
        if (readSize > 0) {
            ByteBuffer buf = this.sslEngineManager.getAppRecvBuf();
            buf.flip();
            int limit = buf.limit();
            ByteBuffer byteBuffer = this.getByteBuffer();
            int capacity = byteBuffer.capacity();
            limit = limit > capacity ? capacity : limit;
            byteBuffer.put(buf.array(), 0, limit);
            buf.position(limit);
            buf.compact();
            byteBuffer.flip();
            this.setChannelID(byteBuffer.getShort());
            short payloadSize = byteBuffer.getShort();
            if (payloadSize < 0) {
                this.setEOS(true);
                payloadSize = -payloadSize;
            }
            payloadSize = (short)(payloadSize - 1);
            byteBuffer.position(4);
            this.setState(BufferState.READING_HEADER);
            byteBuffer.compact();
            byteBuffer.limit(payloadSize);
            this.setState(BufferState.READING_BODY);
            byteBuffer.flip();
            this.setState(BufferState.GETTING);
            return byteBuffer;
        }
        if (readSize < 0) {
            throw new ClosedChannelException();
        }
        return null;
    }

    public boolean write(SocketChannel socketChannel) throws IOException {
        block14: {
            block12: {
                block13: {
                    if (this.sslEngineManager.getPacketSendBuf().position() <= 0) break block12;
                    this.sslEngineManager.handleWrite(socketChannel);
                    if (this.sslEngineManager.getPacketSendBuf().position() <= 0) break block13;
                    this.clear();
                    return false;
                }
                this.clear();
                return true;
            }
            BufferState state = this.getState();
            if (state != BufferState.PUTTING && state != BufferState.WRITING) {
                throw new IllegalStateException(this.toString());
            }
            ByteBuffer byteBuffer = this.getByteBuffer();
            if (state == BufferState.PUTTING) {
                if (this.getChannelID() == Short.MIN_VALUE) {
                    throw new IllegalStateException("channelID == NO_CHANNEL");
                }
                int payloadSize = byteBuffer.position() - 4 + 1;
                if (this.isEOS()) {
                    payloadSize = -payloadSize;
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Writing " + (Math.abs(payloadSize) - 1) + " bytes" + (this.isEOS() ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
                }
                byteBuffer.flip();
                byteBuffer.putShort(this.getChannelID());
                byteBuffer.putShort((short)payloadSize);
                byteBuffer.position(0);
                this.setState(BufferState.WRITING);
            }
            this.sslEngineManager.getAppSendBuf().put(byteBuffer);
            this.sslEngineManager.write(socketChannel);
            if (this.sslEngineManager.getPacketSendBuf().position() <= 0) break block14;
            this.clear();
            return false;
        }
        try {
            this.clear();
            return true;
        }
        catch (IOException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public void dispose() {
        this.sslEngineManager = null;
        super.dispose();
    }
}

