/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ExecutorServiceFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.executorServices";
    public static final String TYPE = "default";
    public static final String DEFAULT_THREAD_GROUP_NAME = "net4j";

    public ExecutorServiceFactory() {
        super(PRODUCT_GROUP, TYPE);
    }

    public ExecutorService create(String threadGroupName) {
        if (threadGroupName == null) {
            threadGroupName = DEFAULT_THREAD_GROUP_NAME;
        }
        final ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
        ThreadFactory threadFactory = new ThreadFactory(){
            private int num;

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r, String.valueOf(threadGroup.getName()) + "-Thread-" + ++this.num);
                thread.setDaemon(true);
                return thread;
            }
        };
        final ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
        return LifecycleUtil.delegateLifecycle(this.getClass().getClassLoader(), executorService, ExecutorService.class, new ILifecycle(){
            private boolean active;

            public void activate() throws LifecycleException {
                this.active = true;
            }

            public Exception deactivate() {
                try {
                    executorService.shutdown();
                    this.active = false;
                    return null;
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            public LifecycleState getLifecycleState() {
                return this.active ? LifecycleState.ACTIVE : LifecycleState.INACTIVE;
            }

            public boolean isActive() {
                return this.active;
            }

            public void addListener(IListener listener) {
            }

            public void removeListener(IListener listener) {
            }

            public IListener[] getListeners() {
                return EventUtil.NO_LISTENERS;
            }

            public boolean hasListeners() {
                return false;
            }
        });
    }

    public static ExecutorService get(IManagedContainer container) {
        return (ExecutorService)container.getElement(PRODUCT_GROUP, TYPE, null);
    }
}

