/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.event;

import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

public class Notifier
implements INotifier {
    private ConcurrentArray<IListener> listeners = new ConcurrentArray<IListener>(){

        protected IListener[] newArray(int length) {
            return new IListener[length];
        }

        @Override
        protected void firstElementAdded() {
            Notifier.this.firstListenerAdded();
        }

        @Override
        protected void lastElementRemoved() {
            Notifier.this.lastListenerRemoved();
        }
    };

    public void addListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        this.listeners.remove(listener);
    }

    public boolean hasListeners() {
        return this.listeners.get() != null;
    }

    public IListener[] getListeners() {
        return this.listeners.get();
    }

    public void fireEvent() {
        this.fireEvent(new Event(this));
    }

    public void fireEvent(IEvent event) {
        if (event != null) {
            this.fireEvent(event, this.getListeners());
        }
    }

    public void fireEvent(final IEvent event, final IListener[] listeners) {
        if (event != null && listeners != null) {
            ExecutorService notificationService = this.getNotificationService();
            if (notificationService != null) {
                notificationService.execute(new Runnable(){

                    public void run() {
                        Notifier.fireEventSafe(event, listeners);
                    }
                });
            } else {
                Notifier.fireEventSafe(event, listeners);
            }
        }
    }

    protected ExecutorService getNotificationService() {
        return null;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    private static void fireEventSafe(IEvent event, IListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            try {
                IListener listener = listeners[i];
                if (listener != null) {
                    listener.notifyEvent(event);
                }
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
            }
            ++i;
        }
    }
}

