/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.common;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.DiagnosticContext;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.EssentialOCLLeft2RightVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotQueries {
    private static final Logger logger = Logger.getLogger(EssentialOCLLeft2RightVisitor.class);

    public static String asIntegerStringOrNull(Element element) {
        if (element instanceof IntegerLiteralExp) {
            return element.toString();
        }
        if (element instanceof UnlimitedNaturalLiteralExp && ((UnlimitedNaturalLiteralExp)element).getUnlimitedNaturalSymbol().signum() >= 0) {
            return element.toString();
        }
        return null;
    }

    public static String asRealStringOrNull(Element element) {
        if (element instanceof RealLiteralExp) {
            return element.toString();
        }
        return null;
    }

    protected static ExpressionInOCL createExpressionInOCLError(String string) {
        ExpressionInOCL expressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        StringLiteralExp stringLiteral = PivotFactory.eINSTANCE.createStringLiteralExp();
        stringLiteral.setStringSymbol(string);
        expressionInOCL.setMessageExpression((OCLExpression)stringLiteral);
        return expressionInOCL;
    }

    protected static PrettyPrintOptions.Global createOptions(Visitable element) {
        MetaModelManager metaModelManager;
        Resource resource;
        Namespace scope = null;
        if (element instanceof ExpressionInOCL) {
            scope = PivotUtil.getNamespace((EObject)((ExpressionInOCL)element).getContextVariable().getType());
        } else if (element instanceof EObject) {
            scope = PivotUtil.getNamespace((EObject)((EObject)element));
        }
        PrettyPrintOptions.Global createOptions = PrettyPrinter.createOptions(scope);
        createOptions.setLinelength(80);
        if (element instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)element)).eResource()) != null && (metaModelManager = MetaModelManager.getAdapter((ResourceSet)resource.getResourceSet())) != null) {
            createOptions.setMetaModelManager(metaModelManager);
        }
        return createOptions;
    }

    protected int getAllSuperClasses(Map<Type, Integer> results, Type aClass) {
        Integer depth = results.get(aClass);
        if (depth != null) {
            return depth;
        }
        int myDepth = 0;
        for (Type superClass : aClass.getSuperClass()) {
            int superDepth = this.getAllSuperClasses(results, superClass);
            if (superDepth < myDepth) continue;
            myDepth = superDepth + 1;
        }
        results.put(aClass, myDepth);
        return myDepth;
    }

    public Type getBehavioralType(Type type) {
        if (type instanceof DataType) {
            DataType dataType = (DataType)type;
            return dataType.getBehavioralType();
        }
        return null;
    }

    public int getDepth(Type aClass) {
        HashMap<Type, Integer> results = new HashMap<Type, Integer>();
        return this.getAllSuperClasses(results, aClass);
    }

    public static ExpressionInOCL getExpressionInOCL(NamedElement contextElement, ValueSpecification specification) {
        if (specification instanceof ExpressionInOCL) {
            return (ExpressionInOCL)specification;
        }
        if (specification instanceof OpaqueExpression) {
            String messageExpression;
            PropertyContext parserContext;
            Resource resource = contextElement.eResource();
            ResourceSet resourceSet = resource.getResourceSet();
            MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
            URI uri = metaModelManager.getResourceIdentifier((Object)specification, null);
            if (contextElement instanceof Property) {
                parserContext = new PropertyContext(metaModelManager, uri, (Property)contextElement);
            } else if (contextElement instanceof Operation) {
                parserContext = new OperationContext(metaModelManager, uri, (Operation)contextElement, null);
            } else if (contextElement instanceof Class) {
                parserContext = new ClassContext(metaModelManager, uri, (Type)((Class)contextElement));
            } else {
                logger.error((Object)"Unknown context type");
                return null;
            }
            OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
            String expression = PivotUtil.getBody((OpaqueExpression)opaqueExpression);
            if (expression == null) {
                return PivotQueries.createExpressionInOCLError("Missing expression");
            }
            ExpressionInOCL expressionInOCL = null;
            try {
                expressionInOCL = parserContext.parse(expression);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage());
                return PivotQueries.createExpressionInOCLError(e.getMessage());
            }
            if (expressionInOCL != null && (messageExpression = PivotUtil.getMessage((OpaqueExpression)opaqueExpression)) != null && messageExpression.trim().length() > 0) {
                try {
                    parserContext = new DiagnosticContext((ParserContext)parserContext, null);
                    parserContext.parse(messageExpression);
                }
                catch (ParserException e) {
                    logger.error((Object)("Failed to parse \"" + messageExpression + "\""), (Throwable)e);
                }
            }
            return expressionInOCL;
        }
        Resource resource = contextElement.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
        ExpressionInOCL expressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        expressionInOCL.setBodyExpression((OCLExpression)metaModelManager.createInvalidExpression());
        return expressionInOCL;
    }

    public static String getFragmentURI(Element element) {
        return EcoreUtil.getURI((EObject)element).fragment().toString();
    }

    public static String getMoniker(Element element) {
        return Pivot2Moniker.toString((Element)element);
    }

    public LinkedHashSet<Operation> getOperations(Type type) {
        ResourceSet resourceSet = type.eResource().getResourceSet();
        MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>();
        for (Operation operation : metaModelManager.getLocalOperations(type, null)) {
            operations.add(operation);
        }
        return operations;
    }

    public LinkedHashSet<Property> getProperties(Type type) {
        ResourceSet resourceSet = type.eResource().getResourceSet();
        MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Property property : metaModelManager.getLocalProperties(type, null)) {
            properties.add(property);
        }
        return properties;
    }

    public String getSignature(Operation anOperation) {
        if (anOperation == null) {
            return "null";
        }
        String qualifiedSignature = PrettyPrinter.printType((Element)anOperation, (Namespace)((Namespace)anOperation.getOwningType()));
        int index = qualifiedSignature.indexOf("::");
        return index > 0 ? qualifiedSignature.substring(index + 2) : qualifiedSignature;
    }

    public static Boolean isBinarySelf(OperationCallExp callExp) {
        if (callExp == null) {
            return false;
        }
        Operation operation = callExp.getReferredOperation();
        if (operation == null) {
            return false;
        }
        EList parameters = operation.getOwnedParameter();
        if (parameters.size() != 1) {
            return false;
        }
        return ((Parameter)parameters.get(0)).getType() instanceof SelfType;
    }

    public static String prettyPrint(Element element) {
        PrettyPrintOptions.Global createOptions = PivotQueries.createOptions((Visitable)element);
        return PrettyPrinter.print((Element)element, (PrettyPrintOptions)createOptions);
    }

    public static String prettyPrintName(Element element) {
        PrettyPrintOptions.Global createOptions = PivotQueries.createOptions((Visitable)element);
        return PrettyPrinter.printName((Element)element, (PrettyPrintOptions)createOptions);
    }
}

