/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.EvaluatorIterationManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;

public class EvaluatorSingleIterationManager
extends EvaluatorIterationManager {
    protected final int depth;
    protected final DomainTypedElement referredIterator;
    protected final EvaluatorIterationManager.ValueIterator iterator;

    public EvaluatorSingleIterationManager(DomainEvaluator invokingEvaluator, DomainExpression body, CollectionValue collectionValue, DomainTypedElement accumulator, Value accumulatorValue, DomainTypedElement referredIterator) {
        super(invokingEvaluator.createNestedEvaluator(), body, collectionValue, accumulator, accumulatorValue);
        this.depth = 0;
        this.referredIterator = referredIterator;
        this.iterator = new EvaluatorIterationManager.ValueIterator(this.evaluator, collectionValue, referredIterator);
    }

    protected EvaluatorSingleIterationManager(EvaluatorSingleIterationManager iterationManager, CollectionValue value) {
        super(iterationManager, value);
        this.depth = iterationManager.depth + 1;
        this.referredIterator = iterationManager.referredIterator;
        this.iterator = new EvaluatorIterationManager.ValueIterator(this.evaluator, this.collectionValue, this.referredIterator);
    }

    public boolean advanceIterators() {
        this.iterator.next();
        return this.hasCurrent();
    }

    public DomainIterationManager createNestedIterationManager(CollectionValue value) {
        return new EvaluatorSingleIterationManager(this, value);
    }

    public Value get() {
        return this.iterator.get();
    }

    public boolean hasCurrent() {
        return this.iterator.hasCurrent();
    }

    public boolean isOuterIteration() {
        return this.depth == 0;
    }
}

