/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainUtil {
    private static final AdapterFactory reflectiveAdapterFactory = new ReflectiveItemProviderAdapterFactory();
    private static final AdapterFactory defaultAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public static String bind(String messageTemplate, Object ... bindings) {
        return NLS.bind((String)messageTemplate, (Object[])bindings);
    }

    public static String debugFullName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getName()) + "@" + Integer.toHexString(object.hashCode());
    }

    public static String debugSimpleName(Object object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(object.getClass().getSimpleName()) + "@" + Integer.toHexString(object.hashCode());
    }

    public static String getLabel(EObject eObject) {
        IItemLabelProvider labeler = (IItemLabelProvider)defaultAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (labeler == null) {
            labeler = (IItemLabelProvider)reflectiveAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        if (labeler != null && eObject != null) {
            return labeler.getText((Object)eObject);
        }
        return String.valueOf(eObject);
    }

    public static String getLabel(EClassifier eClassifier, Object object, Map<Object, Object> context) {
        if (eClassifier instanceof EDataType) {
            return EObjectValidator.getValueLabel((EDataType)((EDataType)eClassifier), (Object)object, context);
        }
        if (object instanceof EObject) {
            if (context != null) {
                return EObjectValidator.getObjectLabel((EObject)((EObject)object), context);
            }
            return DomainUtil.getLabel((EObject)object);
        }
        return String.valueOf(object);
    }

    @Deprecated
    public static void suppressThrowWarnings() throws InvalidValueException {
    }
}

